<?php

namespace App\Helpers;

use App\Models\Booking;
use Carbon\Carbon;

class Utils {

    public static function dateFormatFixedTime($data){
        
        $date = new \DateTime($data);

        // Set the time to 12:30:00 (you can adjust the time as needed)
        $date->setTime(13, 0, 0);

        return $date;
        

    }

    public static function generateBookingId()
    {
        // Get the current year (e.g., 2025)
        $currentYear = Carbon::now()->format('Y');
    
        // Find the latest booking ID for the current year (e.g., 'EDC20250001')
        $latestBooking = Booking::where('booking_id', 'like', 'EDC' . $currentYear . '%')
                                ->orderBy('id', 'desc')
                                ->first();
        
        // If there's no booking for the current year, start with 'EDC20250001'
        if (!$latestBooking) {
            return 'EDC' . $currentYear . '0001';
        }
        
        // Extract the numeric part from the last booking ID (e.g., '0001' from 'EDC20250001')
        $lastIdNumber = (int) substr($latestBooking->booking_id, 8); // Start from position 8 (after 'EDC2025')
        
        // Increment the last ID number
        $newIdNumber = $lastIdNumber + 1;
        
        // Format the new booking ID with leading zeros (e.g., 'EDC20250002')
        $newBookingId = 'EDC' . $currentYear . str_pad($newIdNumber, 4, '0', STR_PAD_LEFT);
    
        return $newBookingId;
    }
}