<?php

namespace App\Livewire\Admin;

use App\Models\CanteenPayment;
use App\Models\Booking;
use App\Models\Canteen;
use App\Models\Payment;
use App\Models\Room;
use App\Models\RoomList;
use Livewire\Component;
use Livewire\WithPagination;
class AcceptAndSelectRoom extends Component
{
    use WithPagination;
    public  $id;
public $bookingId ;
    public $perPage=10;
    public $search ='';
    public $sortBy ='created_at';
    public $sortDir = 'DESC';
    public $roomList;
    public $bookingInRoomListModal;
    public function mount(){
        $this->perPage;
    }

    public function openModal($booking_id){
        $this->id = $booking_id;

    }
    public function openRoomListModal($bookingId){
       // $this->bookingId = $bookingId;
       
        $this->roomList = RoomList::where('booking_id', $bookingId)->get();
        $this->bookingInRoomListModal = Booking::where('booking_id',$bookingId)->first();
       
    }
    public function checkoutBooking($bookingId)
    {
       // dd($bookingId);
        // Ensure booking_id is present
        if (!$bookingId) {
            session()->flash('error', 'Booking ID is missing.');
            return $this->redirect('/admin/acceptandbook');
        }
    
        // Fetch payment record
        $payment = Payment::where('booking_id', $bookingId)->first();
    
        if (!$payment) {
            session()->flash('error', 'No payment record found for this booking.');
            return $this->redirect('/admin/acceptandbook');
        }
    
        // Check if bill was generated
        if ($payment->total_room_amount == 0) {
            session()->flash('error', 'Alert! You need to click "Generate Bill" tab before proceeding to Checkout.');
            return $this->redirect('/admin/acceptandbook');
        }
    
        // Free up rooms
        RoomList::where('booking_id', $bookingId)->get()->each(function ($rl) {
            Room::where('id', $rl->room_id)->update(['is_occupied' => 'no']);
        });
    
        // Update booking status
        $followUpFlag = ($payment->due === 'cleared') ? 'no' : 'yes';
    
        Booking::where('booking_id', $bookingId)->update([
            'booking_status' => 'checked_out',
            'follow_up' => $followUpFlag,
        ]);
    
        session()->flash('success', 'You have checked out the room(s) successfully. Click Rejected/Checked-Out Bookings.');
        return $this->redirect('/admin/acceptandbook');
    }
    public function setSortBy($sortBy){
        if($this->sortBy === $sortBy){
            $this->sortDir = ($this->sortDir=="ASC")? "DESC":"ASC";
        }
        $this->sortBy = $sortBy;
       // $this->sortDir = 'DESC';
       }
    public function render()
    {

  
        $bookings = Booking::whereIn('booking_status',['accepted','checked_in'])
        ->search($this->search) 
        ->orderBy($this->sortBy, $this->sortDir)
        ->paginate($this->perPage);
      
        
        return view('livewire.admin.accept-and-select-room', compact('bookings'));
    }
}
