<?php

namespace App\Livewire\Admin;

use App\Mail\NotifyMail;
use App\Models\Booking;
use App\Models\Guest;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Livewire\Component;

class EditStatus extends Component
{
    public $id;
    public $comment;
    public $status;
    public function mount($id)
    {
        //dd($id);
        $this->id = $id;
    }

    
    public function changeFromPendingToAccept($booking_id,$status)
{
    $this->status = $status;

    if ($status == "rejected") {
        $this->validate([
            'comment'=>'required',
        ]);
        $followup ='no';
    }else{
        $followup = 'yes';
    }
 
    
  
    // Logic for handling the booking rejection
   $booking = Booking::where('id',$booking_id)->firstOrFail();
    if ($booking) {
        $booking->booking_status = $status; // Set status to 'rejected'
        $booking->comment = $this->comment;
        $booking->follow_up = $followup;
        $booking->save();
    }

     if($status == "rejected"){
      
        //Booking::where('guest_id', '=', $booking->guest_id)->delete();

     }
     $info = [
        'name'=>$booking->user->name,
        'status'=>$status,
      'message' => 'Your booking has been ' . $status . ' by the Admin' . ($status === "rejected" ? ' ' .'Reject reason  : ('. $this->comment : ')'),
        
     ]; 
     Mail::to($booking->user->email)->send(new NotifyMail( $info));
   if($status == "rejected"){
    
     $this->redirect('/admin');
   }else{
    $this->redirect('/admin/acceptandbook');
   }
    
}

    public function render()
    {
        $booking = Booking::where('id', $this->id)->first();

        // Ensure that the booking_from and booking_to are already in a correct datetime format
        $time_from = $booking->booking_from->format('Y-m-d H:i:s'); // If booking_from is a Carbon instance
        $time_to = $booking->booking_to->format('Y-m-d H:i:s');   // If booking_to is a Carbon instance

        // Fetch guest details
        $guest = Guest::findOrFail($booking->guest_id);

        $names = DB::table('bookings')
            ->whereIn('booking_status', ['accepted', 'checked_in'])
            ->where(function ($query) use ($time_from, $time_to) {
                $query->where(function ($query) use ($time_from, $time_to) {
                    // Case 1: Booking starts within the time range
                    $query->where('booking_from', '>=', $time_from)
                        ->where('booking_from', '<', $time_to);
                })
                    ->orWhere(function ($query) use ($time_from, $time_to) {
                        // Case 2: Booking ends within the time range
                        $query->where('booking_to', '>', $time_from)
                            ->where('booking_to', '<=', $time_to);
                    })
                    ->orWhere(function ($query) use ($time_from, $time_to) {
                        // Case 3: Booking completely surrounds the time range (starts before and ends after)
                        $query->where('booking_from', '<', $time_from)
                            ->where('booking_to', '>', $time_to);
                    });
            })
            ->get();
        // Calculate the sum of rooms
        $sum = $names->sum('num_rooms');

        return view('livewire.admin.edit-status', compact('booking', 'guest', 'sum'));
    }
}
