<?php

namespace App\Livewire\Admin;

use App\Models\Booking;
use Livewire\Component;
use Livewire\WithPagination;

class FollowUps extends Component
{

    use WithPagination;
    public $perPage=5;
    public $id;
    public $search ='';
    public $sortBy ='created_at';
    public $sortDir = 'DESC';

    public function mount(){
        $this->perPage;
    }

    public function openModal($booking_id){
        $this->id = $booking_id;
       

    }
    public function setSortBy($sortBy){
        if($this->sortBy === $sortBy){
            $this->sortDir = ($this->sortDir=="ASC")? "DESC":"ASC";
        }
        $this->sortBy = $sortBy;
       // $this->sortDir = 'DESC';
       }
    public function render()
    {
        $bookings = Booking::where('booking_status','checked_out')
        ->search($this->search) 
        ->orderBy($this->sortBy, $this->sortDir)
        ->paginate($this->perPage);


        return view('livewire.admin.follow-ups',compact('bookings'));
    }
}
