<?php
namespace App\Livewire\Admin;

use App\Models\Booking;
use App\Models\Canteen;
use App\Models\CanteenPayment;
use App\Models\Payment;
use App\Models\Room;
use App\Models\RoomList;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithPagination;
class ShowAcceptReject extends Component
{

    use WithPagination;
    public $booking = null;
    public $perPage = 10;
    public $search ='';
    public $type = '';
    public $sortBy ='created_at';
    public $sortDir = 'DESC';
    public $selectedImageUrl;
    public $supportingDocUrl;
    // Emit the event from the openModal function
   public function mount(){
    $this->selectedImageUrl=null;
    $this->supportingDocUrl=null;
   }
    public function openModal($bookingId)
    {
        // Retrieve the booking based on the ID
        $this->booking = $bookingId;

        if (!$this->booking) {
            dd('Booking not found!');
        }

        // Emit an event to update the modal
       
    }

   public function setSortBy($sortBy){
    if($this->sortBy === $sortBy){
        $this->sortDir = ($this->sortDir=="ASC")? "DESC":"ASC";
    }
    $this->sortBy = $sortBy;
   // $this->sortDir = 'DESC';
   }

 
public function openIdDocModal($imageUrl)
{
    //dd($imageUrl);
    $this->supportingDocUrl=null;
    $this->selectedImageUrl = $imageUrl;
}

public function openSupportingDocModal($imageUrl)
{
    //dd($imageUrl);
    $this->selectedImageUrl=null;
    $this->supportingDocUrl = $imageUrl;
}
 
public function resetSupportingDoc()
{
    $this->selectedImageUrl = null; // or $this->supportingDocUrl = null;
}


    public function render()
    {
      
        // Get all pending bookings
        $bookings = Booking::where("booking_status", "pending")
        ->search($this->search) // This applies the search scope
        ->orderBy($this->sortBy, $this->sortDir)
        ->paginate($this->perPage); // Paginate results
        $total_booking_amount = Payment::sum('total');
        $booking_pending_amount = Payment::where('due', 'not-cleared')->sum('total');
        $total_canteen_amount = CanteenPayment::sum('total');
        $canteen_pending_amount = CanteenPayment::where('due', 'not-cleared')->sum('total');
                // Pass the booking details to the view
        return view('livewire.admin.show-accept-reject', [
            'bookings' => $bookings,
   
            'id'=>$this->booking,
            'total_booking_amount'=>$total_booking_amount,
            'booking_pending_amount'=>$booking_pending_amount,
            'total_canteen_amount'=>$total_canteen_amount,
            'canteen_pending_amount'=>$canteen_pending_amount,
             // The current booking details
        ]);
    }
}
