<?php

namespace App\Livewire\Booking;

use App\Models\Guest;
use App\Models\GuestAccompanying;
use Livewire\Component;
use App\Helpers\Utils;
use App\Mail\NotifyMail;
use App\Models\Booking;
use DateTime;
use Illuminate\Support\Facades\Mail;
use Livewire\WithFileUploads;
use Carbon\Carbon;

class CreateBooking extends Component
{
    use WithFileUploads;
    public $guest_id;
    public $user_id,
        $purpose,
        $purpose_details,
        $payee, $booking_from,
        $booking_to,
        $floor_preference,
        $booking_status,
        $booking_id,
        $follow_up,
        $num_days,
        $num_rooms,
        $supporting_doc;
    public $totalguests;

    public function mount($id)
    {
        $this->guest_id = $id;
    }

    public function save()
    {

        // Check if guest already has an active booking
        $bookingExisted = Booking::where('guest_id', $this->guest_id)
            ->whereNotIn('booking_status', ['check_out', 'rejected'])
            ->exists();

        if ($bookingExisted) {
            return redirect(route('bookings.current'))
                ->with('success', 'You have already booked room(s) for this guest.');
        }

        

        // Validate form input
        $data = $this->validate([
            'purpose'           => 'required',
            'purpose_details'   => 'required',
            'payee'             => 'required',
            'booking_from'      => 'required|date|after_or_equal:today',
            'booking_to' => [
        'required',
        'date',
        'after_or_equal:booking_from',
        function ($attribute, $value, $fail) {
                    if (!$this->booking_from || !$this->booking_to) return;

                    $from = Carbon::parse($this->booking_from);
                    $to = Carbon::parse($this->booking_to);
                    $days = $from->diffInDays($to) ;

                    if ($days > 3) {
                        $fail("The booking duration cannot exceed 3 days. You selected $days days.");
                    }
                },
          
    ],
            'floor_preference'  => 'required',
            'num_rooms'         => 'required|integer|min:1|max:' . floor($this->totalguests),
           // 'supporting_doc'    => 'required|file|mimes:jpeg,jpg,png,gif,pdf|max:1024'
        ]);



        $dateFrom = new DateTime($data['booking_from']);
        $dateTo = new DateTime($data['booking_to']);
        $dateTo->setTime($dateFrom->format('H'), $dateFrom->format('i'), $dateFrom->format('s'));
        $numberOfDays = $dateFrom->diff($dateTo)->days;
        // $bookingId = Utils::generateBookingId();
    
     if($numberOfDays>3){
        $this->addError('booking_to', 'The booking cannot be more than 3 days long.');
        return;
         }



        // File Upload: Supporting Document
      //  $fileName = Auth()->user()->id . "_" . time() . '_' . $this->supporting_doc->getClientOriginalName();
      //  $photoPath = $this->supporting_doc->storeAs('supporting_doc', $fileName, 'public');
       // initialize data
        $data['booking_status']  = 'draft';
        $data['num_days']        = $numberOfDays;
        $data['user_id']         = Auth()->user()->id;
        $data['guest_id']        = $this->guest_id;
        $data['booking_id']      = Utils::generateBookingId();
        $data['booking_from']    = $dateFrom;
        $data['booking_to']      = $dateTo;
        $data['totalguests']     = $this->totalguests;
       // $data['supporting_doc']  = $photoPath;

        $booking =Booking::create($data);
        $booking_id = $booking->booking_id;
        $info = [
            'name' => Auth()->user()->name,
            'status' => 'Pending',
            'message' => 'Thank you for your booking request. Currently, your booking status is marked as Pending (waiting). You will be notified via email regarding the current status as soon as possible.'
        ];
        // Mail::to(Auth()->user()->name)->send(new NotifyMail($info));
       //$this->redirect('/guests/download/room_request_form_pdf/' . $booking_id);
        $this->redirect('/guests');
    }

    public function render()
    {

        $guest = Guest::where('id', $this->guest_id)->first();

        $accompanyingCount = GuestAccompanying::where('guest_id', $this->guest_id)->count();
        $this->totalguests = $accompanyingCount + 1;

        return view('livewire.booking.create-booking', compact(['guest']));
    }
}
