<?php

namespace App\Livewire\Guest;

use App\Models\Guest;
use App\Models\GuestAccompanying;
use Livewire\Component;

class ShowGuests extends Component
{
   

    public $guestId, $accompanying_guest;
    public $guest_id, $accompaying_name, $accompaying_age, $accompaying_gender, $accompaying_relation,$id;
    public $selectedImageUrl;
    public function delete(Guest $guest){
        //$article = Guest::find($id);
        $guest->delete();
        return redirect('/guests');
     }

    // Property to hold the guest ID

     // This will be triggered when a modal trigger is clicked
     public function openModal($guestId)
     {
         $this->guestId = $guestId;
         
       
     }

  

public function openIdDocModal($imageUrl)
{
    $this->selectedImageUrl = $imageUrl;
}
      public function resetModal(){
         //$this->resetValidation();
         //$this->reset();
         $this->accompaying_name='';
         $this->accompaying_gender='';
         $this->accompaying_relation ='';
      }

public function createAccompanying($id){
    $data = $this->validate([
        'accompaying_name' => 'required|string|min:3',
        'accompaying_gender' => 'required',
        'accompaying_relation' => 'required',
        
    ]);


    $data['guest_id']=$id;
     //   dd(123);
     GuestAccompanying::create($data);
      
        session()->flash('success', 'Accompanying Guest  added successfully');
        $this->redirect('/guests');

}


    public function render()
    {
        
      
        $guests = Guest::where('user_id',Auth()->user()->id)->orderBy('id','DESC')->paginate(5);
        return view('livewire.guest.show-guests', compact('guests'));
    }
}
