<?php

namespace App\Livewire\Guest;

use App\Mail\NotifyMail;
use App\Models\Booking;
use Livewire\Component;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Mail;

class UploadAllocationForm extends Component
{
    use WithFileUploads;

    public $supporting_doc;
    public $booking_id;

    public function mount($booking_id){
        $this->booking_id = $booking_id;
    }

    public function save(){
        $this->validate([
           'supporting_doc' => 'required|file|mimes:jpeg,jpg,png,gif,pdf|max:1024',
        ]);
        $user = auth()->user();
        $fileName = $user->id . '_' .$user->name .'_'. time() . '_' . $this->supporting_doc->getClientOriginalName();
        $photoPath = $this->supporting_doc->storeAs('supporting_doc', $fileName, 'public');
        Booking::where('booking_id', $this->booking_id)->update([
            'booking_status' => 'pending',
            'supporting_doc' => $photoPath,
        ]);

        $info = [
            'name' => Auth()->user()->name,
            'status' => 'Pending',
            'message' => 'Thank you for your booking request. Currently, your booking status is marked as Pending (waiting). You will be notified via email regarding the current status as soon as possible.'
        ];
        Mail::to(Auth()->user()->email)->send(new NotifyMail( $info));
        session()->flash('success', 'Document uploaded successfully!');
        $this->redirect('/guests');
    }
    public function render()
    {
        return view('livewire.guest.upload-allocation-form');
    }
}
  