<?php

namespace App\Livewire\Payment;

use App\Models\Booking;
use App\Models\Canteen;
use App\Models\CanteenPayment;
use App\Models\Payment;
use App\Models\RoomList;
use Livewire\Component;

class GenerateBill extends Component
{

    public $bookingId;
    public function mount($bookingId)
    {

        $this->bookingId = $bookingId;
    }
    public function render()
    {
  

        $booking =  Booking::where('booking_id', $this->bookingId)->firstOrFail();
        $rooms_single = RoomList::where('booking_id', $this->bookingId)
            ->where('occupancy', 'single')
            ->count();



        $rooms_double = RoomList::where('booking_id', $this->bookingId)
            ->where('occupancy', 'double')
            ->count();
        $rooms = RoomList::where('booking_id', $this->bookingId)->get();

        $total_room_charges = 0;
        $categories = [
            'A. Institute Guest' => 'A',
            'B. Departmental Guest' => 'B',
            'C. Close Relative of Employee' => 'C',
            'D. All Other than A, B & C' => 'D',
        ];

        $category = $categories[$booking->guest->guest_relation] ?? null;

        if ($category) {
            $single_room_charge = 0;
            $double_room_charge = 0;

            foreach ($rooms as $room) {
                $single_room_charge += $room->occupancy == 'single' ? env("ROOM_RENT_CAT_{$category}_SINGLE") : 0;
                $double_room_charge += $room->occupancy == 'double' ? env("ROOM_RENT_CAT_{$category}_DOUBLE") : 0;
            }

            $total_room_charges = $single_room_charge + $double_room_charge;
           // dd($total_room_charges);
        }
      // $basic_roomcharge = ($booking->num_rooms * $booking->num_days) * $total_room_charges;
      $basic_roomcharge = ( $booking->num_days) * $total_room_charges;
       // it also includes for canteen
      
       $payment =  Payment::where('booking_id',$this->bookingId)->firstOrFail();
       $canteen=  $payment->canteen;
       $grandTotal = $basic_roomcharge +  $canteen;
//dd($payment->advance, $grandTotal );
       Payment::where('booking_id',$this->bookingId)->update([
        'total_room_amount'=>$basic_roomcharge,
        'total'=>$grandTotal,
        'single_room_amount'=>$single_room_charge,
        'double_room_amount'=> $double_room_charge,
        'due'=>$this->setBalanceFlag($payment->advance, $grandTotal ),
        'canteen'=>0,
     ]);

 
       
      
      $payment = Payment::where('booking_id', $this->bookingId)->first();

      $canteenPayment = CanteenPayment::where('booking_id', $this->bookingId)->first();  
    
        $canteenItems = collect(); // Default to empty collection
        $totalAmount = 0;
    
        if ($canteenPayment) {
            $canteenItems = Canteen::where('canteen_payment_id', $canteenPayment->id)->get();
            $totalAmount = $canteenItems->sum('total');
        }
  

        return view('livewire.payment.generate-bill', compact('booking', 'rooms','payment','canteenItems','rooms_single','rooms_double'));
    }

    private function setBalanceFlag($advance, $total)
    {
        if ($advance > $total) {
            return "Return to Customer";
        } elseif ($advance == $total) {
            return "cleared";
        } else {
            return "not-cleared";
        }
    }
}
