<?php

namespace App\Livewire\Profile;

use App\Mail\NotifyMail;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Livewire\Component;
use Livewire\WithFileUploads;

class CreateProfile extends Component
{
    use WithFileUploads;
    public $name, $phone, $address, $department, $designation, $avatar;
    public $user_type = ''; // Default to 'Employee'
    public $user;
    public function mount(){
        $this->user=User::find(Auth::user()->id);
    }
    public function save()
    {
        // Validation logic
        $this->validate([
            'name' => 'required|string|min:3',
            'phone' => 'required|digits_between:6,10|numeric',
            'address' => 'required',
            'department' => 'required',
            'designation' => 'required',
            'avatar'=>'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'user_type' => 'required',
        ]);
        $photo = $this->user->avatar;

        if ($this->avatar) {
            // Handle the file upload with a unique filename
            $fileName = $this->user->id . "_" . time() . '_' . $this->avatar->getClientOriginalName();
            // Store the avatar file
            if(in_array(strtolower($this->avatar->getClientOriginalExtension()), ['jpeg', 'jpg', 'png', 'gif'])){
            $photo = $this->avatar->storeAs('avatars', $fileName, 'public');  // Store in the 'avatars' folder in the 'public' disk
            }else{
                session()->flash('success', 'Kindly choose image extension only');
                return view('livewire.profile.create-profile');
            }

        }
      
//= $this->avatar->store("photos","public");

        // Update user in the database
        $user = User::find(Auth::user()->id);
        $user->update([
            'name' => $this->name,
            'phone' => $this->phone,
            'address' => $this->address,
            'department' => $this->department,
            'designation' => $this->designation,
            'avatar' =>$photo ,
            'user_type' => $this->user_type,
            'status'=>'registered',
        ]);
        $info = [
            'name'=>Auth()->user()->name,
            'status'=>'Registerd',
            'message'=>'You Have successfull Registered your profile with EDC Booking System. This is one time process only , you can now add guest and proceed for booking '
         ];
         Mail::to(Auth()->user()->email)->send(new NotifyMail( $info));
        // Flash success message
        session()->flash('success', 'Profile updated successfully');
        return redirect('/dashboard');
    }

    public function render()
    {
      
       if($this->user->status=='registered'){
        return view('livewire.profile.update-profile');
       }
        return view('livewire.profile.create-profile');
    }
    
  
}
