<?php

namespace App\Livewire\Profile;

use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\WithFileUploads;
class UpdateProfile extends Component
{
    use WithFileUploads;

    public $name, $phone, $address, $department, $designation, $avatar,$photo;
    public $user_type; // Default to 'Employee'
    public $user;
    public function mount(){
        $user = Auth::user();
        $this->name = $user->name;
        $this->phone = $user->phone;
        $this->address = $user->address;
        $this->department = $user->department;
        $this->designation = $user->designation;
        $this->photo = $user->avatar;
        $this->user_type = $user->user_type;
    }
    public function update()
    {
        // Validation logic
        $this->validate([
            'name' => 'required|string|min:3',
            'phone' => 'required|digits_between:6,10|numeric',
            'address' => 'required',
            'department' => 'required',
            'designation' => 'required',
            'avatar'=>'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'user_type' => 'required',
        ]);
        if ($this->avatar) {
            $fileName = Auth()->user()->id."_".time() . '_' .$this->avatar->getClientOriginalName();  // Get the original file name
             $photo   =  $this->avatar->storeAs('avatars', $fileName, 'public');  // Store in the 'avatars' folder in 'public' disk
        }else{
             $photo = $this->photo;
        }

        // Update user in the database
        $user = User::find(Auth::user()->id);
       
        $user->update([
            'name' => $this->name,
            'phone' => $this->phone,
            'address' => $this->address,
            'department' => $this->department,
            'designation' => $this->designation,
           'avatar' =>$photo ,
            'user_type' => $this->user_type,
           
        ]);

        // Flash success message
        session()->flash('success', 'Profile updated successfully');
        return redirect('/dashboard');
    }

    public function render()
    {  $user = User::find(Auth::user()->id);
        return view('livewire.profile.update-profile',[
            'user'=>$user,
        ]);
    }
}
