<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Booking extends Model
{
   protected $fillable = [
  'user_id','guest_id',
'purpose',
'purpose_details',
'payee','booking_from',
'booking_to',
'canteen_preference',
'floor_preference',
'booking_status',
'booking_id',
'follow_up',
'totalguests','num_rooms','num_days',
'comments','supporting_doc'
   ];

   public function user()
   {
       return $this->belongsTo(User::class);
   }

   protected $casts = [
      'booking_from' => 'datetime',
      'booking_to'=>'datetime'
  ];

  public function guest()
  {
      return $this->belongsTo(Guest::class, 'guest_id'); // Add guest relationship
  }
  //$formattedDate = \Carbon\Carbon::createFromFormat('d-M-Y H:i:s', $value)->format('Y-m-d H:i:s');
  
 /* public function scopeSearch($query, $value)
{
    $query->whereRaw("CONVERT(booking_id USING utf8mb4) COLLATE utf8mb4_unicode_ci LIKE ?", ["%{$value}%"])
          ->orWhereRaw("CONVERT(booking_status USING utf8mb4) COLLATE utf8mb4_unicode_ci LIKE ?", ["%{$value}%"])
          ->orWhereRaw("CONVERT(follow_up USING utf8mb4) COLLATE utf8mb4_unicode_ci LIKE ?", ["%{$value}%"])
          ->orWhereRaw("DATE_FORMAT(booking_from, '%d-%b-%Y') LIKE ?", ["%{$value}%"])
          ->orWhereRaw("DATE_FORMAT(booking_to, '%d-%b-%Y') LIKE ?", ["%{$value}%"])
          ->orWhereHas('user', function($query) use ($value) {
              $query->whereRaw("CONVERT(name USING utf8mb4) COLLATE utf8mb4_unicode_ci LIKE ?", ["%{$value}%"])
                    ->orWhereRaw("CONVERT(designation USING utf8mb4) COLLATE utf8mb4_unicode_ci LIKE ?", ["%{$value}%"]);
          });
}*/
 public function scopeSearch($query, $value)
  {
      $query->where('booking_id', 'like', '%' . $value . '%') // Search in the booking_id
            ->orWhere('booking_status', 'like', '%' . $value . '%')
            ->orWhere('follow_up', 'like', '%' . $value . '%')
           // ->orWhere('booking_from', 'like', '%' . $value . '%')
            ->orWhereRaw("CONVERT(DATE_FORMAT(booking_from, '%d-%b-%Y') USING utf8mb4) COLLATE utf8mb4_unicode_ci LIKE ?", ["%{$value}%"])
            ->orWhereRaw("CONVERT(DATE_FORMAT(booking_to, '%d-%b-%Y') USING utf8mb4) COLLATE utf8mb4_unicode_ci LIKE ?", ["%{$value}%"])
                // Searching for the applicant's name or email via the related user model
          ->orWhereHas('user', function($query) use ($value) {
              $query->where('name', 'like', '%' . $value . '%')
              ->orWhere('designation','like', '%' . $value . '%');
                   
          });
  }
 // App\Models\Booking.php
public function payment()
{
    return $this->hasOne(Payment::class, 'booking_id', 'booking_id');
}


}
