<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Guest extends Model
{
    //
    protected $fillable = [
        'user_id',
'guest_name',
'address',
'city',
'state',
'guest_email',
'guest_gender',
'guest_phone',
'guest_relation','guest_idtype','guest_idno'
    ];

    public function guestAccompaying()
    {
        return $this->hasMany(GuestAccompanying::class);
    }
    public function booking(){
        return $this->hasOne(Booking::class,'guest_id');
    }

    public function user(){
        return $this->belongsTo(User::class);

    }

}
