<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('guest_accompanyings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('guest_id')->constrained()->cascadeOnDelete();
            $table->string('accompaying_name')->nullable();
            $table->unsignedInteger('accompaying_age')->nullable();
            $table->string('accompaying_gender')->nullable();
            $table->string('accompaying_relation')->nullable();
            $table->string('accompaying_idtype')->nullable();
            $table->string('accompaying_idno')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('guest_accompanyings');
    }
};
