<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('canteens', function (Blueprint $table) {
            $table->id();
            $table->foreignId('canteen_payment_id')->constrained('canteen_payments')->cascadeOnDelete();
            $table->string('category');
            $table->string('particulars');
            $table->decimal('rate', 8, 2)->default(0); 
            $table->unsignedSmallInteger('qty')->default(0);
            $table->decimal('total', 8, 2)->default(0); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('canteens');
    }
};
