<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">
    <head>
        @include('partials.head')
    </head>
    <body class="min-h-screen bg-white z-400">
        <flux:sidebar sticky stashable class="border-r border-zinc-200 bg-zinc-50 dark:border-zinc-700 dark:bg-zinc-900">
            <flux:sidebar.toggle class="lg:hidden" icon="x-mark" />

            <a href="{{ route('dashboard') }}" class="flex items-center  " wire:navigate>
               <img src="{{ asset('images/menu_logo2.png') }}"  class="border-2 rounded-lg"> 
            </a>

            <flux:navlist variant="outline">
                <flux:navlist.group heading="Navigation" class="grid">
            
                    <!-- User Section (Collapsible) -->
                    <div id="user-section">
                    
                        @if(Auth()->user()->status=='registered')
                            <!-- User section items -->
                            <details open>
                                <summary class="cursor-pointer" onclick="toggleSection('user-details', 'admin-details')">
                                    <span class="text-red-700">User Menu</span>
                                </summary>
                                <div>
                                    <flux:navlist.item icon="cog" class="size-12" :href="route('dashboard')" :current="request()->routeIs('dashboard')" wire:navigate>{{ __('Dashboard') }}</flux:navlist.item>
                                    <flux:navlist.item icon="a-z-all" :href="route('bookings.current')" :current="request()->routeIs('bookings.current')" wire:navigate>{{ __('Current Bookings') }}</flux:navlist.item>
                                    <flux:navlist.item icon="book-open-text" href="/bookings/all" :current="request()->routeIs('bookings.all')" wire:navigate>{{ __('All Bookings (User)') }}</flux:navlist.item>
                                    <flux:navlist.item icon="users" :href="route('guest.show')" :current="request()->routeIs('guest.show')" wire:navigate>{{ __('Guest List/Request Booking') }}</flux:navlist.item>
                                    <flux:navlist.item icon="download" :href="route('download.room_request_form')" :current="request()->routeIs('download.room_request_form')" wire:navigate>{{ __('↡ Room Request Form') }}</flux:navlist.item>

                                    <div class="flex justify-center">
                                        <a wire:navigate href="/guest/create" variant="primary" size="xs" class="bg-amber-200 px-2 py-1 rounded-lg text-sm hover:bg-indigo-100">Add New Guest</a>
                                    </div>
                                </div>
                            </details>
                        @endif
                    </div>
            
                    <flux:separator class="mt-4"/>
            
                    <!-- Admin Section (Collapsible) -->
                    
                      
                        @if(Auth()->user()->role=='admin')
                        <details open>
                            <summary class="cursor-pointer">
                                <span class="text-red-700">Admin Menu</span>
                            </summary>
                        
                            <div class="inner-items ">
                               <flux:navlist.item icon="cog" class="flex" :href="route('admin')" :current="request()->routeIs('admin')" wire:navigate class="inner-item">
                                 <span class="text-green-500 text-bold">✓ </span> Accept /<span class="text-red-500 text-bold"> ✗ </span> Reject
                                </flux:navlist.item>
                                <flux:navlist.item icon="check" :href="route('admin.acceptandbook')" :current="request()->routeIs('admin.acceptandbook')" wire:navigate class="inner-item">
                                      {{ __('CheckIn/CheckOut/Bill') }}
                                </flux:navlist.item>
                                <flux:navlist.item icon="trash" :href="route('admin.clear_booking')" :current="request()->routeIs('admin.clear_booking')" wire:navigate class="inner-item">
                                     {{ __('Clear/Release Booking') }}
                                </flux:navlist.item>
                                <flux:navlist.item icon="follow" :href="route('admin.followups')" :current="request()->routeIs('admin.followups')" wire:navigate>{{ __('Follow Ups') }}</flux:navlist.item>
                                <flux:navlist.item icon="cross" :href="route('admin.rejected_bookings')" :current="request()->routeIs('admin.rejected_bookings')" wire:navigate>{{ __(' Rejected Bookings') }}</flux:navlist.item>
                                <flux:navlist.item icon="book-open-text" :href="route('admin.all_booking')" :current="request()->routeIs('admin.all_booking')" wire:navigate>{{ __('All Bookings') }}</flux:navlist.item>
                                <flux:navlist.item icon="search" :href="route('admin.search_occupied_rooms')" :current="request()->routeIs('admin.search_occupied_rooms')" wire:navigate>{{ __('Search Rooms Occupied') }}</flux:navlist.item>
                                <flux:navlist.item icon="credit-card" :href="route('admin.booking_report')" :current="request()->routeIs('admin.booking_report')" wire:navigate>{{ __('Booking  Report') }}</flux:navlist.item>

                                
                            </div>
                        </details>
                        @endif
                       
            
                    <flux:separator class="mt-3"/>
            
                    <form method="POST" action="{{ route('logout') }}" class="w-full">
                        @csrf
                        <flux:menu.item as="button" type="submit" icon="arrow-right-start-on-rectangle" class="w-full cursor-pointer">
                            {{ __('Log Out') }}
                        </flux:menu.item>
                    </form>
            
                </flux:navlist.group>
            </flux:navlist>
            
           
            
            <flux:spacer />

            <flux:navlist variant="outline">
               
                <flux:navlist.item icon="a-z-all" href="/workflow_diagram" >
                {{ __('Work Flow/Help') }}
                </flux:navlist.item>
            </flux:navlist>

            <!-- Desktop User Menu -->
            <flux:dropdown position="bottom" align="start">
                <flux:profile
                    :name="auth()->user()->name"
                    :initials="auth()->user()->initials()"
                    icon-trailing="chevrons-up-down"
                />

                <flux:menu class="w-[220px]">
                    <flux:menu.radio.group>
                        <div class="p-0 text-sm font-normal">
                            <div class="flex items-center gap-2 px-1 py-1.5 text-left text-sm">
                                <span class="relative flex h-8 w-8 shrink-0 overflow-hidden rounded-lg">
                                    <span
                                        class="flex h-full w-full items-center justify-center rounded-lg bg-neutral-200 text-black dark:bg-neutral-700 dark:text-white"
                                    >
                                        {{ auth()->user()->initials() }}
                                    </span>
                                </span>

                                <div class="grid flex-1 text-left text-sm leading-tight">
                                    <span class="truncate font-semibold">{{ auth()->user()->name }}</span>
                                    <span class="truncate text-xs">{{ auth()->user()->email }}</span>
                                </div>
                            </div>
                        </div>
                    </flux:menu.radio.group>

                    <flux:menu.separator />

                    <flux:menu.radio.group>
                        <flux:menu.item href="/settings/profile" icon="cog" wire:navigate>{{ __('Settings') }}</flux:menu.item>
                    </flux:menu.radio.group>

                    <flux:menu.separator />

                    <form method="POST" action="{{ route('logout') }}" class="w-full">
                        @csrf
                        <flux:menu.item as="button" type="submit" icon="arrow-right-start-on-rectangle" class="w-full">
                            {{ __('Log Out') }}
                        </flux:menu.item>
                    </form>
                </flux:menu>
            </flux:dropdown>
        </flux:sidebar>

        <!-- Mobile User Menu -->
        <flux:header class="lg:hidden">
            <flux:sidebar.toggle class="lg:hidden" icon="bars-2" inset="left" />

            <flux:spacer />

            <flux:dropdown position="top" align="end">
                <flux:profile
                    :initials="auth()->user()->initials()"
                    icon-trailing="chevron-down"
                />

                <flux:menu>
                    <flux:menu.radio.group>
                        <div class="p-0 text-sm font-normal">
                            <div class="flex items-center gap-2 px-1 py-1.5 text-left text-sm">
                                <span class="relative flex h-8 w-8 shrink-0 overflow-hidden rounded-lg">
                                    <span
                                        class="flex h-full w-full items-center justify-center rounded-lg bg-neutral-200 text-black dark:bg-neutral-700 dark:text-white"
                                    >
                                        {{ auth()->user()->initials() }}
                                    </span>
                                </span>

                                <div class="grid flex-1 text-left text-sm leading-tight">
                                    <span class="truncate font-semibold">{{ auth()->user()->name }}</span>
                                    <span class="truncate text-xs">{{ auth()->user()->email }}</span>
                                </div>
                            </div>
                        </div>
                    </flux:menu.radio.group>

                    <flux:menu.separator />

                    <flux:menu.radio.group>
                        <flux:menu.item href="/settings/profile" icon="cog" wire:navigate>Settings</flux:menu.item>
                    </flux:menu.radio.group>

                    <flux:menu.separator />

                    <form method="POST" action="{{ route('logout') }}" class="w-full">
                        @csrf
                        <flux:menu.item as="button" type="submit" icon="arrow-right-start-on-rectangle" class="w-full">
                            {{ __('Log Out') }}
                        </flux:menu.item>
                    </form>
                </flux:menu>
            </flux:dropdown>
        </flux:header>

        {{ $slot }}

        @fluxScripts
    </body>
    <script>
    // Function to toggle sections (show/hide)
    function toggleSsection(sectionId) {
        var section = document.getElementById(sectionId);
        if (section.style.display === "none" || section.style.display === "") {
            section.style.display = "block"; // Show section
        } else {
            section.style.display = "none"; // Hide section
        }
    }
</script>
</html>
