<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">
    <head>
        @include('partials.head')
    </head>
    <body class="min-h-screen bg-white antialiased dark:bg-linear-to-b dark:from-red-950 dark:to-neutral-900">
        <div class="relative grid h-dvh flex-col items-center justify-center px-8 sm:px-0 lg:max-w-none lg:grid-cols-2 lg:px-0">
            <div class="bg-muted hidden lg:flex flex-col h-full p-10 text-white dark:border-r dark:border-neutral-800 relative">
                <!-- Background Image Overlay -->
                <div class="absolute inset-0 bg-gray-500 bg-cover bg-center w-full z-10 " 
                 style="background-image: url('/images/edc_pic1.jpg')"></div>
                
                <!-- Dark Overlay -->
                
            
                <!-- App Logo with Navigation -->
                <div class="flex justify-center">
                <a href="{{ route('home') }}" class="relative z-20 flex items-center text-lg font-medium" wire:navigate>
                   
                       <img src="/images/menu_logo2x.png" class="text-center"/>
                   
                   
                </a>
            </div>
   
            
                <!-- Image Box Section -->
                
            </div>
            
            
            <div class="w-full lg:p-8">
                <div class="mx-auto flex w-full flex-col justify-center space-y-6 sm:w-[350px]">
                    <a href="{{ route('home') }}" class="z-20 flex flex-col items-center gap-2 font-medium lg:hidden" wire:navigate>
                        <span class="flex h-9 w-9 items-center justify-center rounded-md">
                            <x-app-logo-icon class="size-9 fill-current text-black dark:text-white" />
                        </span>

                        <span class="sr-only">{{ config('app.name', 'Laravel') }}</span>
                    </a>
                    {{ $slot }}
                </div>
            </div>
        </div>
        @fluxScripts
    </body>
</html>
