<x-layouts.app>

    <div class="h-full w-full ">
        <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->


        <!-- This part will remain as a full-width element (one column) -->
        <div class="relative h-full flex-1  rounded-xl border border-gray-300 px-4 pb-4">
            <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15" />

            <div class="relative mb-3 p-4 w-full  ">
                <div class="flex justify-between items-center">
                    <div>
                        <h1 class="text-3xl text-red-900">My Profile</h1>
                        <flux:subheading size="lg" class="mb-2">
                            {{ __('Manage your profile and account settings') }}</flux:subheading>
                    </div>
                    <div><img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}" class="w-16 border-1 p-1 rounded-full border-gray-700" /></div>
                </div>
                <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
            </div>
            @if (!Auth()->user()->phone)
                <div class="text-md mb-3">Welcome <span class="text-red-800 border-b border-gray-500">
                        {{ Auth()->user()->name }}</span> to the Guest House Booking System !</div>
                <div class="mb-5">Your profile is <span
                        class="text-red-800 border-b border-gray-500 font-bold">incomplete</span>. To start booking
                    rooms for your guest(s),
                    begin by registering your basic profile with us.</div>

                <div class="flex justify-around mx-auto">
                    <div>
                        <flux:button icon="arrow-up-tray" variant="primary" class="mx-auto" wire:navigate
                            href="/profile/create">Click Here </flux:button> to complete your profile
                    </div>
                </div>
                <div class="text-sm mt-3"><b>Note:</b> This is a one-time process. You won't need to complete your
                    profile again after next logging in.
                </div>
            @else
            <x-custom.message/>
            <div class="w-full mx-auto flex flex-col sm:flex-row">
                <table class="w-full sm:w-2/3 mx-auto border border-gray-500 p-2 border-collapse rounded-lg">
                    <tbody class="border-collapse">
            
                        <tr class="border-b bg-gray-100">
                            <td class="px-3 py-4 font-bold">Name</td>
                            <td class="px-3 py-4"><flux:badge color="amber">{{ Auth()->user()->name }}</flux:badge></td>
                        </tr>
            
                        <tr class="border-b">
                            <td class="px-3 py-4 font-bold">Institute's Email</td>
                            <td class="px-3 py-4">{{ Auth()->user()->email }}</td>
                        </tr>
            
                        <tr class="border-b bg-gray-100">
                            <td class="px-3 py-4 font-bold">Phone Number</td>
                            <td class="px-3 py-4">{{ Auth()->user()->phone }}</td>
                        </tr>
            
                        <tr class="border-b">
                            <td class="px-3 py-4 font-bold">Type</td>
                            <td class="px-3 py-4"><flux:badge color="yellow">{{ Auth()->user()->user_type }}</flux:badge></td>
                        </tr>
            
                        <tr class="border-b bg-gray-100">
                            <td class="px-3 py-4 font-bold">Employee Id/ Registration No.</td>
                            <td class="px-3 py-4">{{ Auth()->user()->unique_id }}</td>
                        </tr>
            
                        <tr class="border-b">
                            <td class="px-3 py-4 font-bold">Department</td>
                            <td class="px-3 py-4">{{ Auth()->user()->department }}</td>
                        </tr>
            
                        <tr class="border-b bg-gray-100">
                            <td class="px-3 py-4 font-bold">Designation / Course</td>
                            <td class="px-3 py-4">{{ Auth()->user()->designation }}</td>
                        </tr>
            
                        <tr class="border-b">
                            <td class="px-3 py-4 font-bold">Profile Created On</td>
                            <td class="px-3 py-4">{{ date_format(Auth()->user()->created_at,'d-M-Y') }}</td>
                        </tr>
            
                    </tbody>
                </table>
            
                <div class="mt-10 text-center  sm:mt-0">
                    <flux:button wire:nagivation href="/profile/update" class="w-full sm:w-48 cursor-pointer" type="submit" variant="primary">Update</flux:button>
                    <flux:description class="mt-2 text-sm">Note: Only few fields, such as phone, designation, are allowed to be updated.</flux:description>
                    <div class="mt-10 "> <flux:button wire:nagivation href="/guest/create" class="w-full sm:w-48 bg-amber-700 cursor-pointer" type="submit" variant="primary" style="width: 120px;">Add New Guest </flux:button>
                        <flux:description class="mt-2 text-sm">New Booking Request</flux:description>
                    </div>
                </div>
            </div>
            
            @endif
            <div class="mt-6 text-2xl text-red-900"><u>Application Flow for User:</u>
            </div>
            <ul class="list-disc ml-10 space-y-2 text-gray-700 mt-3">
                <li>After the login , complete your profile . This is one time process for fresh registration</li>
                <li>During profile registration, select the user type, choose a department, designation/course, and provide other necessary details.</li>
                <li>Once the registration is complete, you can begin the booking process by adding new guest details by clicking Add New Button.</li>
                <li> Contact Administrator for any Query</li>
                <li>These instructions are for testing purposes and will be finalized later. <li>
            </ul>


        </div>
</x-layouts.app>
