<div class="h-full w-full">
    <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->
    <div class="relative h-full flex-1 rounded-xl border border-gray-300 px-4 pb-4">
        <!-- Placeholder pattern (Ensure this doesn't overlap the form) -->
        <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15 z-0 pointer-events-none" />

        <div class="relative mb-0 p-4 w-full z-10">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl text-red-900">All Bookings </h1>
                    <flux:subheading size="lg" class="mb-2">{{ __('You can Edit, Delete the guests & Book Room') }}
                    </flux:subheading>
                </div>
                <div>
                    <img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}"
                        class="w-16 border-1 p-1 rounded-full border-gray-700" />
                </div>
            </div>
            <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
        </div>
        <div class="mt-0 flex justify-end">
       
            <flux:button type="submit" variant="filled" class="ml-auto border border-gray-400" size="sm">Back to
                Profile</flux:button>
        </div>
        <x-custom.message />


        <div class="mt-3 w-full  border"><div class="text-md bg-yellow-400"><span class=" px-2">Click on the Booking ID to view guest details & the list of accompanying persons.</span></div>
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-left text-gray-800 dark:text-gray-400">
                <!-- First Header Row -->
                <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                    <tr class="border bg-gray-100 text-black font-medium">
                        <td class="px-3 py-2">Booking Id <br/>(Booked On)</td>
                        <td class="px-3 py-2">Applicant</td>
                      
                        <td class="px-3 py-2">Purpose</td>
                        <td class="px-3 py-2">Days</td>
                        <td class="px-3 py-2">Total Guest(s)</td>
                        <td class="px-3 py-2">Status</td>
                     
                        <td class="px-3 py-2">Booking_From to Booking_Till</td>

                    
                        <td class="px-3 py-2">Floor</td>
                        <td class="px-3 py-2">Payee</td>
                           
                    </tr>
                </thead>

                <tbody>
                    <!-- First Body Row (first set of data) -->
                 
                        
                  
                        
                    @forelse ($all_bookings as $booking)
                        <tr class="text-start border-b text-md">
                            <td class="px-3 py-2 text-sm"><a href="/guests/{{ $booking->guest_id }}/view" class="text-white
                                cursor-pointer  bg-gray-500 px-2 rounded-lg hover:text-black
                                 hover:bg-amber-200">{{ $booking->booking_id }} </a><br/>
                                 ({{ date('d-M-Y',strtotime($booking->created_at)) }})</td>
                            <td class="px-3 py-2">{{ $booking->user->name }}</td>
                         
                            <td class="px-3 py-2">{{ $booking->purpose }}</td>
                            <td class="px-3 py-2">{{ $booking->num_days }}</td>
                            <td class="px-3 py-2">{{ $booking->totalguests }}</td>
                            <td class="px-3 py-2 text-start"><flux:badge variant="solid" size="sm" color="primary" >
                                 @if($booking->booking_status=='draft')
                                Saved as Draft
                               @else
                               {{ $booking->booking_status }}
                            @endif</flux:badge><br>
                                @if($booking->booking_status=='rejected')
                                Reason: <span class="text-red-800"> {{ $booking->comment }}</span>
                                     @endif</td>
                            
                            <td class="px-3 py-3 text-sm">{{ date('d-M-Y',strtotime($booking->booking_from)) }}<br/> to <br/> {{date('d-M-Y',strtotime($booking->booking_to)) }} </td>
                        
                            <td class="px-3 py-2">{{ $booking->floor_preference }}</td>
                            <td class="px-3 py-2">{{ $booking->payee }}</td>
                           
                            
                        </tr>
                        
                   
                    @empty
                    <tr><td colspan="9" class="text-red-600 text-center text-xl py-3 "><div class=""  > No Current Booking Found! </div><div class="flex justify-center"><img src="{{ asset('images/warning.png') }}" class="w-10 rounded-full border p-1 border-gray-800"> </div></td></tr>
                    @endforelse
                </tbody>
            </table>
            </div>
        </div>
        <!-- Second Header Row -->
    

    </div>
    <!-- JavaScript to toggle the display -->

