<div class="h-full w-full">
    <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->
    <div class="relative h-full flex-1 rounded-xl border border-gray-300 px-4 pb-4">
        <!-- Placeholder pattern (Ensure this doesn't overlap the form) -->
        <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15 z-0 pointer-events-none" />

        <div class="relative mb-3 p-4 w-full z-10">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl text-red-900">Request Booking </h1>
                    <flux:subheading size="lg" class="mb-2">{{ __('Add the details of main guest') }}
                    </flux:subheading>
                </div>
                <div>
                    <img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}"
                        class="w-16 border-1 p-1 rounded-full border-gray-700" />
                </div>
            </div>
            <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
        </div>

        <ul class="list-disc ml-5">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>

        <div class="w-full mx-auto">
            <div class="text-end text-xl me-20"><u>Total No. Guest(s): <span class="text-red-600">
                        <b>{{ $totalguests }}</b></span></u></div>
            <form wire:submit.prevent="save" class="space-y-4 z-40 relative grid grid-cols-1 sm:grid-cols-2 gap-4"
                enctype="multipart/form-data">

                <!-- First column -->
                <div>
                    <flux:label> Purpose of Visit</flux:label>
                    <flux:select wire:model="purpose">
                        <flux:select.option value="" selected>Choose Purpose of visit</flux:select.option>
                        <flux:select.option>Official</flux:select.option>
                        <flux:select.option>Non-official</flux:select.option>
                    </flux:select>
                    <flux:error name="purpose" />
                </div>
                <div>
                    <flux:label> Payee</flux:label>
                    <flux:select wire:model="payee">
                        <flux:select.option value="" selected>Choose Payee</flux:select.option>
                        <flux:select.option>Applicant</flux:select.option>
                        <flux:select.option>Guest</flux:select.option>

                    </flux:select>
                    <flux:error name="payee" />
                </div>



                <!-- Second column -->
                <div>
                    <flux:field>
                        <flux:label>No. of Rooms *</flux:label>
                        <flux:input wire:model="num_rooms" type="number" placeholder="No. of Rooms"
                            placeholder="Enter rooms between  1 (min.) and {{ $totalguests }} (max.) " max="3" required />
                        <flux:error name="num_rooms" />
                    </flux:field>
                </div>
                <div>
                    <flux:field>
                        <flux:label>No. of Days *</flux:label>
                        <flux:input type="number" value="" id="num_days" disabled readonly
                            placeholder="No of Days"
                            style="color:red; font-weight:bolder; font-size:16px; background:rgb(229, 227, 227)"
                            class="bg-gray-200 " />
                        <flux:error name="num_days" />

                    </flux:field>
                </div>


                <!-- 3rd row for User Type -->

                <flux:field>
                    <flux:textarea wire:model="purpose_details" rows="3" label="Details of Visit"
                        placeholder="Enter your purpose_details" />
                </flux:field>
                <div>
                    <span class="text-red-800 me-3">Selected Guest Category:</span>
                    {{ $guest->guest_relation }}
                    <div>Tariff</div>
                    <table class="w-full border text-gray-500">
                        <thead>
                            <tr>
                                <th>S.No.</th>
                                <th>Occupancy</th>
                                <th>Revised Rates in Rs.</th>
                            </tr>
                        </thead>
                        <tbody class="border text-center">
                            @if ($guest->guest_relation == 'C. Close Relative of Employee')
                                <tr>
                                    <td>1.</td>
                                    <td>Single Occupancy</td>
                                    <td>900.00</td>
                                </tr>
                                <tr>
                                    <td>2.</td>
                                    <td>Double Occupancy</td>
                                    <td>1000.00</td>
                                </tr>
                            @elseif ($guest->guest_relation == 'A. Institute Guest')
                                <tr>
                                    <td>1.</td>
                                    <td>Single Occupancy</td>
                                    <td>0.00</td>
                                </tr>
                                <tr>
                                    <td>2.</td>
                                    <td>Double Occupancy</td>
                                    <td>0.00</td>
                                </tr>
                            @elseif ($guest->guest_relation == 'B. Departmental Guest')
                                <tr>
                                    <td>1.</td>
                                    <td>Single Occupancy</td>
                                    <td>500.00</td>
                                </tr>
                                <tr>
                                    <td>2.</td>
                                    <td>Double Occupancy</td>
                                    <td>700.00</td>
                                </tr>
                            @else
                                <tr>
                                    <td>1.</td>
                                    <td>Single Occupancy</td>
                                    <td>1500.00</td>
                                </tr>
                                <tr>
                                    <td>2.</td>
                                    <td>Double Occupancy</td>
                                    <td>2000.00</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>

                <!--  Fourth -->
                <div>
                    <label for="start-date">Booking From Date (Check In) :</label>
                    <flux:description>(The booking date must be today or a future date)</flux:description>
                    <div><input wire:model="booking_from" type="datetime-local" id="start-date" name="booking_from"
                            min="{{ \Carbon\Carbon::today()->format('Y-m-d H:i:s') }}"
                            class="border w-full px-3 py-2 rounded-lg bg-white" required>
                    </div>
                    <flux:error name="booking_from" />
                </div>
                <div>
                    <label for="start-date">
                        Booking To Date ( Check Out) </label>
                    <flux:description>(Checkout time will be the same as Check-in time.)</flux:description>

                    <div>
                        <input wire:model="booking_to" type="date" id="end-date" name="booking_to"
                            class="border w-full px-3 py-2 rounded-lg bg-white" >

                    </div>
                    <flux:error name="booking_to" />
                </div>

                <!-- Conditional Designation or Course -->
                <div>
                    <flux:label> Floor Preference</flux:label>
                    <flux:select wire:model="floor_preference" placeholder="Choose Gender">
                        <flux:select.option value="" selected>Choose Floor</flux:select.option>
                        <flux:select.option>Ground Floor</flux:select.option>
                        <flux:select.option>First Floor</flux:select.option>
                        <flux:select.option>Second Floor</flux:select.option>
                        <flux:select.option>Third Floor</flux:select.option>
                    </flux:select>
                    <flux:error name="floor_preference" />
                </div>

              {{--   <div class="flex items-center gap-4">
                    <flux:input type="file" wire:model="supporting_doc"
                        label="Upload Forwarded/Supporting Document(Allowed formats : pdf, jpeg,jpg,png below 1MB)" />
                    @if ($supporting_doc)
                        @php
                            $ext = strtolower($supporting_doc->getClientOriginalExtension());
                        @endphp

                        @if (in_array($ext, ['jpeg', 'jpg', 'png', 'gif']))
                            <img src="{{ $supporting_doc->temporaryUrl() }}"
                                class="h-16 w-16 object-cover rounded-full" />
                        @elseif($ext === 'pdf')
                            <div class="flex flex-col items-center space-y-2">
                                <span class="text-gray-700">PDF File</span>

                            </div>
                        @else
                            <span class="text-red-500">Invalid file type. Please upload an image or PDF.</span>
                        @endif
                    @endif

                </div> --}}

                <!-- Profile Picture Upload -->


                <!-- Conditionally show ID Number input or text message -->


                <flux:button type="submit" variant="primary" class="mt-6">Download Allotment Request Form
                </flux:button>
            </form>
        </div>
    </div>
</div>

{{-- <script>
function getISTDate() {
    const now = new Date();
    now.setMinutes(now.getMinutes() + 330); // Adjust UTC to IST (UTC +5:30)
    return now.toISOString().split('T')[0]; // Get date only (YYYY-MM-DD)
}

function initializeDates() {
    const startDateInput = document.getElementById('start-date');
    const endDateInput = document.getElementById('end-date');
    const numDaysInput = document.getElementById('num_days');

    const todayIST = getISTDate(); // Get today's date in IST

    startDateInput.min = todayIST; // Disable past dates for Booking From
    endDateInput.min = todayIST;   // Disable past dates for Booking To

    startDateInput.addEventListener('change', updateBookingTo);
    endDateInput.addEventListener('change', calculateNumDays);
}

function updateBookingTo() {
    const startDateInput = document.getElementById('start-date');
    const endDateInput = document.getElementById('end-date');

    if (!startDateInput.value) return;

    const startDateTime = new Date(startDateInput.value);
    const nextDay = new Date(startDateTime);
    nextDay.setDate(nextDay.getDate() + 1); // Booking To must be at least the next day

    endDateInput.min = nextDay.toISOString().split('T')[0]; // Update min date for Booking To

    // Reset Booking To if it's before the required date
    if (endDateInput.value && new Date(endDateInput.value) < nextDay) {
        endDateInput.value = "";
    }
}

function calculateNumDays() {
    const startDateInput = document.getElementById('start-date');
    const endDateInput = document.getElementById('end-date');
    const numDaysInput = document.getElementById('num_days');

    if (!startDateInput.value || !endDateInput.value) return;

    const startDate = new Date(startDateInput.value);
    const endDate = new Date(endDateInput.value);

    const numDays = Math.ceil((endDate - startDate) / 86400000); // Convert ms to days
    numDaysInput.value = numDays > 0 ? numDays : '';
}

window.onload = function () {
    initializeDates();
    document.getElementById('start-date').addEventListener('change', updateBookingTo);
    document.getElementById('end-date').addEventListener('change', calculateNumDays);
};
</script> --}}
<script>
    function getISTDate() {
        const now = new Date();
        now.setMinutes(now.getMinutes() + 330); // Convert to IST (UTC+5:30)
        return now.toISOString().split('T')[0]; // Return only the date (YYYY-MM-DD)
    }

    function initializeDates() {
        const startDateInput = document.getElementById('start-date');
        const endDateInput = document.getElementById('end-date');
        const numDaysInput = document.getElementById('num_days');

        const todayIST = new Date(new Date().toLocaleString("en-US", { timeZone: "Asia/Kolkata" }));
       // todayIST.setMinutes(todayIST.getMinutes() +330); // Adjust for local time
 
        const todayFormatted = todayIST.toISOString().split('T')[0]; // Extract YYYY-MM-DD

        startDateInput.setAttribute("min", todayFormatted);
        endDateInput.setAttribute("min", todayFormatted);

        startDateInput.addEventListener('change', () => {
            updateBookingTo();
            calculateNumDays();
        });

        endDateInput.addEventListener('change', () => {
            calculateNumDays();
        });
    }

    function updateBookingTo() {
        const startDateInput = document.getElementById('start-date');
        const endDateInput = document.getElementById('end-date');

        if (!startDateInput.value) return;

        const startDate = new Date(startDateInput.value);

        // Set min = start + 1 day
        const minDate = new Date(startDate);
        minDate.setDate(minDate.getDate() );
        endDateInput.min = minDate.toISOString().split('T')[0];

        // Set max = start + 3 days
        const maxDate = new Date(startDate);
        maxDate.setDate(maxDate.getDate() + 3);
        endDateInput.max = maxDate.toISOString().split('T')[0];

        // Reset Booking To if it's out of range
        const endDate = new Date(endDateInput.value);
        if (endDateInput.value && (endDate < minDate || endDate > maxDate)) {
            endDateInput.value = "";
        }
    }

    function calculateNumDays() {
    const startDateInput = document.getElementById('start-date');
    const endDateInput = document.getElementById('end-date');
    const numDaysInput = document.getElementById('num_days');

    if (!startDateInput.value || !endDateInput.value) {
        numDaysInput.value = "";
        return;
    }

    // Parse only date parts (ignore time) to avoid timezone/time precision issues
    const startDate = new Date(startDateInput.value.split("T")[0]);
    const endDate = new Date(endDateInput.value.split("T")[0]);

    // Calculate difference in milliseconds
    const diffTime = endDate.getTime() - startDate.getTime();

    // Convert to days (add 1 if you want to include both start and end days)
    const numDays = diffTime / (1000 * 60 * 60 * 24);

    numDaysInput.value = numDays >= 0 ? numDays : '';
}

    window.onload = function() {
        initializeDates();
    };
</script>
