<div class="h-full w-full">
    <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->
    <div class="relative h-full flex-1 rounded-xl border border-gray-300 px-4 pb-4">
        <!-- Placeholder pattern (Ensure this doesn't overlap the form) -->
        <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15 z-0 pointer-events-none" />

        <div class="relative mb-3 p-4 w-full z-10">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl text-red-900">Add Canteen Charges</h1>
                    <flux:subheading size="lg" class="mb-2">{{ __('Complete your profile to register with EDC.') }}
                    </flux:subheading>
                </div>
                <div>
                    <img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}"
                        class="w-16 border-1 p-1 rounded-full border-gray-700" />
                </div>
            </div>
            <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
        </div>
        <x-custom.message />
        <div class="w-3xl mx-auto">
            <form wire:submit.prevent="save" class="space-y-4 z-10 relative grid grid-cols-1 gap-4">
        
                <!-- Category Selection -->
                
                <div>
                    <flux:label>Select Category </flux:label>
                      <select wire:model="category"   class="border rounded px-2 py-1 w-full bg-gray-100 text-gray-500 cursor-not-allowed" disabled>
                        <option value="">-- Select Category --</option>
                        <option value="B">B. Departmental Guest</option>
                        <option value="C">C. Close Relative of Employee</option>
                        <option value="D">D. All Other than A, B & C</option>
                    </select>
                    <flux:error name="category" />
                </div>
        
                <!-- Items List -->
                <div class="flex flex-col">
                    <div class="w-75 my-3"><flux:input wire:model="advance" type="number" name="advance" label="Adavance amount" value="0" class=" "/></div>
                    <div>
                        <button type="button" wire:click="addItem" class="bg-green-500 text-white p-2 rounded">+ Add Item</button>
                    </div>
        
                    @foreach ($items as $index => $item)
                        <div class="flex w-full items-center space-x-4 mt-2">
                            <div>
                                <flux:label>Particulars</flux:label>
                                <flux:select wire:model.live="items.{{ $index }}.particulars">
                                    <flux:select.option value="" selected>Choose Item...</flux:select.option>
                                    <flux:select.option>Breakfast</flux:select.option>
                                    <flux:select.option>Lunch</flux:select.option>
                                    <flux:select.option>Dinner</flux:select.option>
                                    <flux:select.option>Lunch (Special)</flux:select.option>
                                    <flux:select.option>Dinner (Special)</flux:select.option>
                                    <flux:select.option>Tea</flux:select.option>
                                    <flux:select.option>Coffee</flux:select.option>
                                    <flux:select.option>Milk</flux:select.option>
                                </flux:select>
                            </div>
        
                            <div>
                                <flux:label>Rate in ₹</flux:label>
                                <flux:input type="number" wire:model.live="items.{{ $index }}.rate" readonly/>
                            </div>
        
                            <div>
                                <flux:label>Qty</flux:label>
                                <flux:input type="number" wire:model.live="items.{{ $index }}.qty"/>
                            </div>
        
                            <div>
                                <flux:label>Total</flux:label>
                                <div class="px-3 py-2 w-25 border border-gray-300 rounded-lg">
                                    ₹ {{ number_format($items[$index]['total'] ?? 0, 2) }}
                                </div>
                            </div>
        
                            <div class="mt-2">
                                <button type="button" wire:click="removeItem({{ $index }})" class="bg-red-500 text-white px-3 py-2 rounded text-sm"> Remove</button>
                            </div>
                        </div>
                    @endforeach
                </div>
        
                <!-- Submit Button -->
                <div>
                    <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded">Add Canteen Charges</button> 
                    <a  wire:click="resetCanteenAmount" class="bg-green-700 text-white px-4 py-2 rounded">Reset Canteen Charges</a>
                </div>
        
            </form>
        </div>
        
        

        <!-- Department Selection -->


        <!-- Conditional Designation or Course -->


        <!-- Profile Picture Upload -->


        <!-- Submit Button -->
        
    </div>
</div>
</div>

<!-- JavaScript to toggle the display -->
