<div class="h-full w-full">
    <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->
    <div class="relative h-full flex-1 rounded-xl border border-gray-300 px-4 pb-4">
        <!-- Placeholder pattern (Ensure this doesn't overlap the form) -->
        <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15 z-0 pointer-events-none" />
        
        <div class="relative mb-0 p-4 w-full z-10">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl text-red-900">Guest's List </h1>
                    <flux:subheading size="lg" class="mb-2">{{ __('You can Edit, Delete the guests & Book Room') }}
                    </flux:subheading>
                </div>
                <div>
                    <img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}"
                        class="w-16 border-1 p-1 rounded-full border-gray-700" />
                </div>
            </div>
            <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
        </div>{{ $accompanying_guest }}
        <div class="mt-0 flex justify-end">
           
            <flux:button type="submit" variant="filled" class="ml-auto border border-gray-400" size="sm">Back to
                Profile</flux:button>
        </div>
        <x-custom.message />
        <div class="mt-3 w-full ">
            <div class="bg-yellow-400 my-auto px-2"> Note: Click Add ⊕ button to enter the details of Additonal
                person(s) above 12 years accompanying the guest. </div>
                <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                    <thead class="text-xs text-gray-400 uppercase bg-gray-50">
                        <tr class="border bg-gray-100 text-black font-medium">
                        <td class="px-3 py-4">S.No.</td>
                        <td class="px-3 py-4">Guest Name (Main)</td>
                        <td class="px-3 py-4">Modify</td>
                        <td class="px-3 py-4">Accompanying Guest</td>
                        <td class="px-3 py-4">View ID</td>
                        <td class="px-3 py-4">Supporting Doc</td>
                        <td class="px-3 py-4">Action/Status</td>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($guests as $guest)
                        <tr class="border-b">
                            <td class="px-3 py-4">{{ $guests->firstItem() + $loop->index }}</td>
                            <td class="px-3 py-4">{{ $guest->guest_name }}</td>

                            <td class="px-3 py-4 flex">
                                
                                @if(!optional($guest->booking)->booking_status) <a wire:navigate href="/guests/{{ $guest->id }}/edit" size="sm"
                                    variant="primary"> <flux:icon.pencil-square class="p-1 text-green-700" /><sup class="text-sxs">Edit</sup></a> 
                                    @else<div class="relative inline-block">
                                        <!-- Your original icon -->
                                        <flux:icon.pencil-square class="p-1 text-green-700" /><sup class="text-sxs">Edit</sup>
                                        
                                        <!-- The cross symbol positioned on top -->
                                        <span class="absolute bottom-4 right-2 text-red-500 text-xl font-bold ">x</span>
                                    </div> @endif|
                                <a wire:navigate wire:click="delete({{ $guest->id }})" wire:confirm="Are you sure you want to delete {{ $guest->guest_name }}"
                                    size="sm" variant="danger">
                                    <flux:icon.trash class="text-amber-700 p-1 cursor-pointer" /><sup> &nbsp;Delete</sup>
                                </a>
                            </td>
                            <td class="px-3 py-4">
                                @if(!optional($guest->booking)->booking_status) <flux:modal.trigger name="add-accompanyingGuest"
                                    wire:click="openModal({{ $guest->id }})">
                                    <flux:button variant="primary" size="xs" icon="plus" class="bg-yellow-600">
                                        Add</flux:button>
                                </flux:modal.trigger>@else
                              <flux:button variant="primary" size="xs" icon="plus" disabled class="bg-yellow-500">
                                    Add(disabled)</flux:button>
                                @endif
                                
                                    <flux:button wire:navigation variant="primary" href="/guests/{{ $guest->id }}/view" size="xs" icon="eye" class="bg-gray-500">
                                        List</flux:button>
                                     
                            </td>

                            <td class="text-center">
                                @if($guest->guest_idno)<flux:modal.trigger name="view-guestId"
                                wire:click="openIdDocModal('{{ asset('storage/'.$guest->guest_idno) }}')">
                                    @if($guest->guest_idno)
                                    <img 
                                    id="guestImage"
                                    src="{{ asset('storage/'.$guest->guest_idno) }}" 
                                 
                                    class="w-12 h-10 cursor-pointer rounded-xl border border-gray-400 " 
                                    alt="Guest ID"
                                  /> @else
                                  View PDF
                                  @endif
                                </flux:modal.trigger>
                                @else
                                At Check-In
                                @endif
                                 
                              
                            </td>
                            <td class="px-4 py-3"> @if ($guest->booking && $guest->booking->supporting_doc)
                                <flux:modal.trigger 
                                    name="view-supportingdoc"
                                    wire:click="openIdDocModal('{{ asset('storage/'.$guest->booking->supporting_doc) }}')" 
                                    class="cursor-pointer"
                                >
                                    View
                                </flux:modal.trigger>
                            @else
                                <span class="text-gray-400 italic">No document</span>
                            @endif
                                </td>
                           
                            <td class="px-3 py-4">
                                @if(empty(optional($guest->booking)->booking_status ))
                                <a href="/booking/create/{{ $guest->id }}"> Request Booking (🏨) </a>
                            @elseif($guest->booking->booking_status=='draft')
                            
                                   <flux:button href="/guests/download/room_request_form_pdf/{{ $guest->booking->booking_id }}" variant="primary" size="sm" class="bg-amber-200 text-black hover:bg-red-200 cursor-pointer"> Click to Complete Booking</flux:button>
                            @else
                                <flux:badge variant="solid" icon="star" size="sm" color="zinc">
                                    {{ optional($guest->booking)->booking_status }}
                                   
                                </flux:badge> <br>
                                @if($guest->booking->booking_status=='rejected')
                               Reason: <span class="text-red-800"> {{ $guest->booking->comment }}</span>
                                    @endif
                            @endif
                             
                            </td>


                        </tr>
                    @empty
                        <tr>
                            <tr><td colspan="7" class="text-red-600 text-center text-xl py-3 ">
                                <div class=""  > No Guest(s)  Found! </div>
                                <div class="flex justify-center"><img src="{{ asset('images/warning.png') }}" class="w-10 rounded-full border p-1 border-gray-800"> </div></td></tr>

                        </tr>
                    @endforelse

                </tbody>
            </table>
            @if(empty($guests))
            <div class="flex justify-end">
                <div class="flex w-100  bg-yellow-100 mt-3 ">1.
                    <flux:icon.eye class=" p-1  text-blue-700 text-bold " /></a> = View &nbsp;&nbsp;&nbsp;&nbsp;2.
                    <flux:icon.pencil-square class=" p-1  text-green-700" /></a> = Edit &nbsp;&nbsp;&nbsp;&nbsp; 3.
                    <flux:icon.trash class="text-amber-700 p-1  cursor-pointer" /></a> = Delete &nbsp;&nbsp;&nbsp;&nbsp;
                    4. <flux:icon.plus class="text-amber-700 p-1  cursor-pointer" /></a> = Add
                </div>

            </div>
            @endif
            <div class="w-1/2 mt-5 text-red-500">

                {{ $guests->links() }}
            </div>
        </div>
       
        
    </div>
    <!-- JavaScript to toggle the display -->
    <flux:modal name="add-accompanyingGuest" class="w-96 md:w-200">
        <div class="space-y-6">
            <div>
                <flux:heading size="lg">Accompanying Guest</flux:heading>
                <flux:subheading>Add details of Accompanying Guest </flux:subheading>
            </div>

            <form wire:submit="createAccompanying({{ $guestId }})" class="space-y-6">
                <flux.field>
                    <flux:input wire:model="accompaying_name" label="Name of the Accompanying Guest:"
                        placeholder="Accompanying Guest's Name" type="text" />

                </flux.field>

                <div class="mt-4">
                    <flux:select wire:model="accompaying_gender" placeholder="" label="Gender">

                        <flux:select.option>Choose Gender</flux:select.option>
                        <flux:select.option>Male</flux:select.option>
                        <flux:select.option>Female</flux:select.option>
                        <flux:select.option>Prefer Not to say</flux:select.option>

                    </flux:select>
                </div>


                <flux:input wire:model="accompaying_relation" label="Guest's Relationship with Accompanying Person"
                    placeholder="Realtionship with Accompanying Guest's Name" type="text" />
                </flux.field>
                <div class="flex">
                    <flux:spacer />
                    <flux:button wire:click="resetModal" variant="primary" class="me-6">Reset</flux:button>
                    <flux:button type="submit" variant="primary">Save changes</flux:button>
                </div>
            </form>
        </div>
    </flux:modal>

    <flux:modal name="view-guestId" class="w-96 md:w-400">
        <div class="space-y-6">
            <div>
                <flux:heading size="lg">Guest Id Document</flux:heading>
                <flux:subheading>Uploaded Guest's Id  </flux:subheading>
            </div>

            <div class="text-center">
               {{-- @if ($selectedImageUrl)
                    <img src="{{ $selectedImageUrl }}" alt="Guest ID" class="max-w-full max-h-[80vh] mx-auto rounded" />
                @else
                    <p>No image selected.</p>
                @endif --}}
                
                
                  @if ($selectedImageUrl)
                    @php
                        $ext = strtolower(pathinfo(parse_url($selectedImageUrl, PHP_URL_PATH), PATHINFO_EXTENSION));
                    @endphp
    
                    @if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif']))
                        <img src="{{ $selectedImageUrl }}" alt="Guest ID" class="max-w-full max-h-[80vh] mx-auto rounded" />
    
                    @elseif ($ext === 'pdf')
                        <iframe 
                            src="{{ $selectedImageUrl }}" 
                            class="w-full h-[80vh] rounded border"
                            frameborder="0"
                        ></iframe>
    
                    @else
                        <p class="text-red-500">Unsupported file type.</p>
                    @endif
                @else
                    <p>No file selected.</p>
                @endif
            </div>
        </div>
    </flux:modal>


    <flux:modal name="view-supportingdoc" class="w-96 md:w-400">
        <div class="space-y-6">
            <div>
                <flux:heading size="lg">Guest Id Document</flux:heading>
                <flux:subheading>Uploaded Guest's ID</flux:subheading>
            </div>
    
            <div class="text-center">
                @if ($selectedImageUrl)
                    @php
                        $ext = strtolower(pathinfo(parse_url($selectedImageUrl, PHP_URL_PATH), PATHINFO_EXTENSION));
                    @endphp
    
                    @if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif']))
                        <img src="{{ $selectedImageUrl }}" alt="Guest ID" class="max-w-full max-h-[80vh] mx-auto rounded" />
    
                    @elseif ($ext === 'pdf')
                        <iframe 
                            src="{{ $selectedImageUrl }}" 
                            class="w-full h-[80vh] rounded border"
                            frameborder="0"
                        ></iframe>
    
                    @else
                        <p class="text-red-500">Unsupported file type.</p>
                    @endif
                @else
                    <p>No file selected.</p>
                @endif
            </div>
        </div>
    </flux:modal>
