<div class="h-full w-full">
    <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->
    <div class="relative h-full flex-1 rounded-xl border border-gray-300 px-4 pb-4">
        <!-- Placeholder pattern (Ensure this doesn't overlap the form) -->
        <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15 z-0 pointer-events-none" />

        <div class="relative mb-0 p-4 w-full z-10">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl text-red-900">View Guest Details </h1>
                    <flux:subheading size="lg" class="mb-2">{{ __('You can Edit, Delete the guests & Book Room') }}
                    </flux:subheading>
                </div>
                <div>
                    <img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}"
                        class="w-16 border-1 p-1 rounded-full border-gray-700" />
                </div>
            </div>
            <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
        </div>
        <div class="mt-0 flex justify-end">
            
            <flux:button type="submit" variant="filled" class="ml-auto border border-gray-400" size="sm">Back to
                Profile</flux:button>
        </div>
        <x-custom.message />
        <div class="w-full">

            <table class="w-full">
                <tbody class="border-collapse">

                    <tr class="border-b bg-gray-100">
                        <td class="px-3 py-4 font-bold">Guest Name</td>
                        <td class="px-3 py-4">
                            <flux:badge color="amber">{{ $guest->guest_name }}</flux:badge>
                        </td>
                    </tr>

                    <tr class="border-b">
                        <td class="px-3 py-4 font-bold">Guest's Email & Phone </td>
                        <td class="px-3 py-4">Email: {{ $guest->guest_email }} &nbsp;&nbsp;&nbsp;&nbsp; Phone:
                            {{ $guest->guest_phone }}</td>
                    </tr>



                    <tr class="border-b">
                        <td class="px-3 py-4 font-bold">City - State</td>
                        <td class="px-3 py-4">{{ $guest->city }} - {{ $guest->state }}</td>
                    </tr>

                    <tr class="border-b bg-gray-100">
                        <td class="px-3 py-4 font-bold">Relation with Guest</td>
                        <td class="px-3 py-4">{{ $guest->guest_relation }}</td>
                    </tr>

                    <tr class="border-b">
                        <td class="px-3 py-4 font-bold">Type of Id Provided </td>
                        <td class="px-3 py-4">{{ $guest->guest_idtype }} selected</td>
                    </tr>


                </tbody>
            </table>


        </div>

        <h2 class="text-lg mt-6 "><span class="border-b bg-amber-200 px-2">Accompanying Guest List:</span></h2>
        <div class="w-full mt-3">

            <table class="w-3/4 text-sdm text-left text-gray-600 dark:text-gray-400">
                <thead class="text-xs text-gray-800 uppercase bg-gray-50">
    
    <tr class="border bg-gray-300">
    <th class="px-3 py-3 ">S.no</th>
    <th class="px-3 py-3 ">Accompaying Guest's Name</th>
    <th class="px-3 py-3 ">Gender</th>
    <th class="px-3 py-3 ">Relation</th>
    <th class="px-3 py-3 ">Action</th>

</tr></thead>
<tbody class="text-sdm">
    @forelse ($accomapanyings as $accomapany )
        <tr class="text-centter border-b">
            <td class="px-3 py-3  text-center"  >{{ $loop->iteration }}</td>
            <td class="px-3 py-3 ">{{ $accomapany->accompaying_name }}</td>
            <td class="px-3 py-3 ">{{ $accomapany->accompaying_gender }}</td>
            <td class="px-3 py-3 ">{{ $accomapany->accompaying_relation}}</td>
            <td class="px-3 py-3 "><a wire:click="delete({{ $accomapany->id }})" 
                wire:confirm="Are you sure you want to delete {{ $accomapany->accompaying_name }}" class="flex items-center" > 
                <flux:icon.trash class="text-red-600 p-1 cursor-pointer size-8" /> <sub class="text-sdm">(Delete)</sub></a></td>
        </tr>
    @empty
    <tr><td colspan="4" class="flexs text-red-600 text-center text-xl py-3 w-full">
        <div class="text-md"  > No Current Booking Found! </div>
        <div class="flex justify-center"><img src="{{ asset('images/warning.png') }}" class="w-16 rounded-full border p-1 border-gray-500"> </div></td></tr>
    @endforelse
</tbody>

            </table>
        </div>

    </div>
    <!-- JavaScript to toggle the display -->
