<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use App\Models\Payment;
use App\Models\RoomList;
use App\Models\Room;
use App\Models\Booking;
class CheckOut extends Component
{
  public $booking_id;
    public function mount($bookingId){
        $this->booking_id = $bookingId;
    }
    public function render()
    {

       // Ensure booking_id is present
    if (!$this->booking_id) {
        session()->flash('error', 'Booking ID is missing.');
        $this->redirect('/admin/acceptandbook');
    }

    // Fetch payment record or fail
    $payment = Payment::where('booking_id', $this->booking_id)->first();

    if (!$payment) {
        session()->flash('error', 'No payment record found for this booking.');
        $this->redirect('/admin/acceptandbook');
    }

    // Check if bill was generated
    if ($payment->total_room_amount == 0) {
        session()->flash('error', 'Alert! You need to click "Generate Bill" tab before proceeding to Checkout.');
        $this->redirect('/admin/acceptandbook');
    }
         // UPDATE rooms rm, room_lists rl SET rm.is_occupied = 'no' WHERE rl.booking_id='201800001' and rl.room_id = rm.id;

       $rl = RoomList::where('booking_id',$this->booking_id)->get();
        for ($x = 0; $x < count($rl); $x++){  // to upadte one-to-one ids
       
         Room::where('id',$rl[$x]->room_id)->update(array(
                 'is_occupied' => 'no',
             ));
 
        }   
          // Set follow-up flag based on due
         $followUpFlag = ($payment->due === 'cleared') ? 'no' : 'yes';
 
        Booking::where('booking_id', $this->booking_id)->update(array(
            'booking_status' => 'checked_out',
            'follow_up'=>$followUpFlag,
        ));
        session()->flash('error', 'You have Checked out the room(s) successfully,  click   Rejected/Checked-Out Bookings');
    
        
      $this->redirect('/admin/acceptandbook');
    }
}
