<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use App\Models\Booking;
use Livewire\WithPagination;
class DeleteBookings extends Component
{

    use WithPagination;
    public $perPage=5;
    public $id;
    public $search ='';
    public $sortBy ='created_at';
    public $sortDir = 'DESC';
    public function mount(){
        $this->perPage;
    }

    public function openModal($booking_id){
        $this->id = $booking_id;
       

    }
    public function setSortBy($sortBy){
        if($this->sortBy === $sortBy){
            $this->sortDir = ($this->sortDir=="ASC")? "DESC":"ASC";
        }
        $this->sortBy = $sortBy;
       // $this->sortDir = 'DESC';
       }
    public function deleteBooking(Booking $booking){
    
        $booking->delete();
        return redirect('/admin/clear_booking');
    }
    public function render()
    {
        $bookings = Booking::where('booking_status','accepted')
        ->search($this->search) 
        ->orderBy($this->sortBy, $this->sortDir)
        ->paginate($this->perPage);

        return view('livewire.admin.delete-bookings',compact('bookings'));
    }
}
