<?php

namespace App\Livewire\Admin;

use App\Models\Booking;
use App\Models\Room;
use Livewire\Component;
use Livewire\WithPagination;
class SearchRoomOccupied extends Component
{
    use WithPagination;
    public $perPage=5;
    public $id;
    public $sortBy ='created_at';
    public $sortDir = 'DESC';
    public $time_from;
    public $time_to;
    public $bookings = [];
    public $rooms_occupied = 0;
    public $rooms_available = 0;
    public $total_rooms = 0;
    public function mount(){
        $this->perPage;
    }

    public function openModal($booking_id){
        $this->id = $booking_id;
       

    }
    public function setSortBy($sortBy){
        if($this->sortBy === $sortBy){
            $this->sortDir = ($this->sortDir=="ASC")? "DESC":"ASC";
        }
        $this->sortBy = $sortBy;
       // $this->sortDir = 'DESC';
       }

    public function NumOfRoomsOccupied(){
        
        $this->validate([
            'time_from' => 'required|date',
            'time_to'   => 'required|date|after_or_equal:time_from',
        ]);

        $timeFrom = date('Y-m-d H:i:s', strtotime($this->time_from));
        $timeTo = date('Y-m-d H:i:s', strtotime($this->time_to));

        $this->bookings = Booking::whereIn('booking_status', ['accepted', 'checked_in'])
            ->where(function ($query) use ($timeFrom, $timeTo) {
                $query->where(function ($q) use ($timeFrom, $timeTo) {
                    $q->where('booking_from', '<=', $timeFrom)
                      ->where('booking_to', '>', $timeFrom);
                })->orWhere(function ($q) use ($timeFrom, $timeTo) {
                    $q->where('booking_from', '<', $timeTo)
                      ->where('booking_to', '>=', $timeTo);
                })->orWhere(function ($q) use ($timeFrom, $timeTo) {
                    $q->where('booking_from', '>=', $timeFrom)
                      ->where('booking_to', '<=', $timeTo);
                });
            })
            ->orderBy($this->sortBy, $this->sortDir)
            ->get();
            $this->total_rooms = env('TOTAL_ROOMS');
           
        $this->rooms_occupied = $this->bookings->sum('num_rooms');
        $this->rooms_available = $this->total_rooms - $this->rooms_occupied;
    }
    public function render()
    {
        
   
        return view('livewire.admin.search-room-occupied');
    }
}
