<?php

namespace App\Livewire\Admin;

use App\Models\Booking;
use App\Models\Payment;
use App\Models\Room;
use App\Models\RoomList;
use Livewire\Component;

class SelectRooms extends Component
{
    public $booking_id;
    public $advance=0.00;
    public $rooms_array;
    public $occupancy_array;
    public function mount($bookingId)
    {
        $this->booking_id = $bookingId;
    }

    public function store(){

        $this->validate([
            'rooms_array' => 'required',
        'advance' => 'required|numeric|min:0',
        ],[
            'rooms_array.required'=>'You have selected any Room. Click on the room(s)',
        ]);

        $arrayofrooms = (json_decode($this->rooms_array));

        $arrayofoccupany = (json_decode($this->occupancy_array));
        foreach ($arrayofoccupany as $room_id => $occupancy) {
           
            RoomList::create([
                'booking_id'=>$this->booking_id ,
                'room_id'=>$room_id,
                'occupancy' => $occupancy
            ]);
            Room::where('id',$room_id)->update(['is_occupied'=>'yes',
                //'type'=> $occupancy
                 ]); 
        }

       /*  for ($x = 0; $x < count($arrayofrooms); $x++) {

               
            RoomList::create([
            'booking_id'=>$this->booking_id ,
           //\\ 'room_status'=>'checked_in', //please remove
            
            'room_id'=>$arrayofrooms[$x],
             ]);

            Room::where('id',$arrayofrooms[$x])->update(['is_occupied'=>'yes']); //please remove 'booking_id'=>$booking_id
        

        } */

        Booking::where('booking_id', $this->booking_id)->update([
            'num_rooms' => count($arrayofrooms), //as number of guest appearing on actual checked in day may vary
            'booking_status'=>'checked_in',
        ]);
      // Mail checked in and instruction make sure to settle the due Bills and collect the bill reciept
        Payment::create([
            'booking_id'=>$this->booking_id,
            'advance'=> $this->advance, 

      ]);
   
      $this->redirect('/admin/acceptandbook');
    }
    public function render()
    {

        $rooms = Booking::where('booking_id', $this->booking_id)->firstOrFail();

       

        // Count occupied and total rooms directly
        $total_rooms = Room::all();
        $occupied_rooms = Room::where('is_occupied', 'yes')->count();
        $room_available_today = $total_rooms->count() - $occupied_rooms;
        return view('livewire.admin.select-rooms', compact('rooms', 'total_rooms', 'room_available_today'));
        // return view('rooms.create',compact('rooms','room_no','room_available_today'));
        
    }
}
