<?php

namespace App\Livewire\Booking;

use App\Models\Booking;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class ViewBookings extends Component
{
    public function render()
    {
       
        $current_bookings = Booking::where('user_id', Auth::user()->id)
        ->where('booking_from', '>=', Carbon::today())->orderBy('id', 'DESC')->get();
        return view('livewire.booking.view-bookings',compact('current_bookings'));
    }
}
