<?php

namespace App\Livewire\Canteen;

use App\Models\Booking;
use App\Models\Canteen;
use App\Models\CanteenPayment;
use App\Models\Payment;
use Livewire\Component;

class CreateCanteen extends Component
{

    public $category;
    public $booking_id;
    public $items = [];
    public $advance=0;
    private $rates = [
        'B' => ['Breakfast' => 75.00, 'Lunch' => 125.00, 'Dinner' => 125.00,'Lunch (Special)'=>175.00,
        'Dinner (Special)'=>175.00,'Tea'=>10,00,'Coffee'=>20.00,'Milk'=>25.00],
        'C' => ['Breakfast' => 75.00, 'Lunch' => 125.00, 'Dinner' => 125.00, 'Lunch (Special)'=>175.00,
        'Dinner (Special)'=>175.00,'Tea'=>10,00,'Coffee'=>20.00,'Milk'=>25.00],
        'D' => ['Breakfast' => 150.00, 'Lunch' => 300.00, 'Dinner' => 300.00, 'Lunch (Special)'=>500,00,
        'Dinner (Special)'=>500.00,'Tea'=>20,00,'Coffee'=>50,00,'Milk'=>50.00],
    ];
    public function mount($booking_id)
    {
          $booking = Booking::with('guest')->where('booking_id', $booking_id)->first();

    if ($booking && $booking->guest) {
        $map = [
            'B. Departmental Guest' => 'B',
            'C. Close Relative of Employee' => 'C',
            'D. All Other than A, B & C' => 'D',
        ];

        $this->category = $map[$booking->guest->guest_relation] ?? '';
    } 
  
    $this->booking_id = $booking_id;
    $this->items = [
        ['particulars' => '', 'rate' => 0, 'qty' => 0, 'total' => 0]
    ];
    }

    public function addItem()
    {
        $this->items[] = ['particulars' => '', 'rate' => 0, 'qty' => 0, 'total' => 0];
    }

    public function removeItem($index)
    {
        unset($this->items[$index]);
        $this->items = array_values($this->items);
    }

    // When category or item is updated, auto-fill rate
    public function updated($propertyName)
    {
        $this->validate([
            'category' => 'required',
        ]);
        if (str_starts_with($propertyName, 'items')) {
            foreach ($this->items as $index => $item) {
                $category = $this->category;
                $particulars = $item['particulars'] ?? '';

                // Auto-fill rate if category exists
                if ($category && isset($this->rates[$category][$particulars])) {
                    $this->items[$index]['rate'] = $this->rates[$category][$particulars];
                }

                // Auto-calculate total
                $rate = (float) ($this->items[$index]['rate'] ?? 0);
                $qty = (int) ($this->items[$index]['qty'] ?? 0);
                $this->items[$index]['total'] = $rate * $qty;
            }
        }
    }
    /*  public function updatedItems($value, $index)
    {
        // Auto-calculate total when rate or quantity changes
        if (isset($this->items[$index]['rate']) && isset($this->items[$index]['qty'])) {
            $rate = (float) ($this->items[$index]['rate'] ?? 0);
            $qty = (int) ($this->items[$index]['qty'] ?? 0);
            $this->items[$index]['total'] = $rate * $qty;
        }
    } */

    public function save()
    {
        $this->validate([
            'category' => 'required',
        ]);
    
        // Check if canteen items already exist for this booking
        $canteenPayment = CanteenPayment::where('booking_id', $this->booking_id)->first();
    
        if ($canteenPayment && Canteen::where('canteen_payment_id', $canteenPayment->id)->exists()) {
            session()->flash('error', 'Canteen items already added. Reset to add again. It will remove the previous added item for this booking Id');
            return;
        }
    
        $totalCanteenAmount = 0;
    
        // Create or get the CanteenPayment record
        $canteenPayment = CanteenPayment::firstOrCreate(
            ['booking_id' => $this->booking_id],
            ['advance' => 0]
        );
    
        foreach ($this->items as $item) {
            if (!isset($item['particulars'], $item['rate'], $item['qty'])) {
                continue;
            }
    
            $itemTotal = (float) $item['rate'] * (int) $item['qty'];
            $totalCanteenAmount += $itemTotal;
    
            Canteen::create([
                'canteen_payment_id' => $canteenPayment->id,
                'category' => $this->category,
                'particulars' => $item['particulars'],
                'rate' => $item['rate'],
                'qty' => $item['qty'],
                'total' => $itemTotal,
            ]);
        }
        CanteenPayment::where('booking_id', $this->booking_id)->update([
            'total'=> $totalCanteenAmount,
            'advance'=>$this->advance,
            'due'=>$this->setBalanceFlag($this->advance,  $totalCanteenAmount),
          ]);
        session()->flash('success', 'Canteen items saved successfully!');
    
        // Reset form
        $this->reset(['items']);
        $this->items = [['particulars' => '', 'rate' => 0, 'qty' => 0, 'total' => 0]];
        $this->advance=0; 
        $this->redirect(route('admin.generate_canteen_bill', $this->booking_id));
    }
    
    public function resetCanteenAmount()
    {
        $canteenPayment = CanteenPayment::where('booking_id', $this->booking_id)->first();
    
        if ($canteenPayment) {
            Canteen::where('canteen_payment_id', $canteenPayment->id)->delete();
            session()->flash('success', 'Canteen items reset successfully!');
        }
    }
    private function setBalanceFlag($advance, $total)
    {
        if ($advance > $total) {
            return "Return to Customer";
        } elseif ($advance == $total) {
            return "cleared";
        } else {
            return "not-cleared";
        }
    }

    public function render()
    {
        $booking = Booking::where('booking_id', $this->booking_id)->first();

        return view('livewire.canteen.create-canteen', compact('booking'));
    }
}
