<?php

namespace App\Livewire\Guest;

use App\Models\Guest;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\WithFileUploads;
class CreateGuest extends Component
{
    use WithFileUploads;
    public $guest_name, $address, $city,$state,$guest_email;
    public $guest_gender,$guest_phone,$guest_relation,$guest_idtype,$guest_idno;


    public $user;
    public function mount(){
        $this->user=User::find(Auth::user()->id);
    }
    public function addGuest()
    {
        $data = $this->validate([
            'guest_name'      => 'required',
            'address'         => 'required',
            'city'            => 'required',
            'state'           => 'required',
            'guest_gender'    => 'required',
            'guest_phone'     => 'required|digits_between:6,10|numeric',
            'guest_relation'  => 'required',
            'guest_idtype'    => 'required',
            'guest_idno'      => ($this->guest_idtype == "Will Provide during Check-In") ? 'nullable' : 'required|file|mimes:jpeg,jpg,png,gif,pdf',
        ]);
    
        $photoPath = null;
    
        if ($this->guest_idno && $this->guest_idtype != "Will Provide during Check-In") {
            $fileName = Auth()->user()->id . "_" . time() . '_' . $this->guest_idno->getClientOriginalName();
            $photoPath = $this->guest_idno->storeAs('guestIds', $fileName, 'public'); // saves in storage/app/public/guestIds
        }
    
        $data['guest_idno'] = $photoPath; // store path like guestIds/1_1743185451_user.png
        $data['user_id'] = Auth()->user()->id;
    
        Guest::create($data);
    
        session()->flash('success', 'New Guest added successfully.');
        return redirect('/guests');
    }
    public function render()
    {
        return view('livewire.guest.create-guest');
    }
}
