<?php

namespace App\Livewire\Guest;

use App\Models\Guest;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class EditGuest extends Component
{
public $guest;
    public $guest_name,
        $address, $city,$state,$guest_email,$guest_gender,$guest_phone,
         $guest_relation, $guest_idtype, $guest_idno,$id;
  
public function mount( $id){
   
    $guest = Guest::FindOrFail($id);
    if( $guest->user_id != Auth()->user()->id){
        abort('403');
    }
    $this->guest_name =  $guest->guest_name;
    $this->address =  $guest->address;
    $this->city =  $guest->city;
    $this->state =  $guest->state;
    $this->guest_email =  $guest->guest_email;
    $this->guest_gender =  $guest->guest_gender;
    $this->guest_phone =  $guest->guest_phone;
    $this->guest_relation =  $guest->guest_relation;
    $this->guest_idtype =  $guest->guest_idtype;
    $this->guest_idno =  $guest->guest_idno;

  }

  public function update(){
    $data = $this->validate([
        'guest_name'=>'required',
        'address'=>'required',
        'city'=>'required',
        'state'=>'required',
        'guest_email'=>'nullable',
        'guest_gender'=>'required',
        'guest_phone'=>'required',
        'guest_relation'=>'required',
        'guest_idtype'=>'required',
        'guest_idno'=>($this->guest_idtype=="Will Provide during Check-In")?'nullable':'required',
    ]);

   if($data['guest_idtype']=="Will Provide during Check-In"){
    $data['guest_idno'] = '';
   }
   Guest::find($this->id)
            ->update($data);
    
    session()->flash('success', 'Guest Updated successfully');
    $this->redirect('/guests');

    
}
    public function render()
    {
        return view('livewire.guest.edit-guest');
    }
}
