<?php

namespace App\Livewire\Guest;

use App\Models\Booking;
use App\Models\Guest;
use App\Models\GuestAccompanying;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\WithFileUploads;
class RoomRequestForm extends Component
{
    use WithFileUploads;

    public $booking_id;
    public $supporting_doc;

    public function mount($booking_id){
        $this->booking_id = $booking_id;
    }


  
    public function render()
    { 
       // dd(Auth::user()->id);
       
        $booking = Booking::where('booking_id',$this->booking_id)->first();
         $guest = Guest::where('id',$booking->guest_id)->first();
        $accompanyingGuests = GuestAccompanying::where('guest_id',$guest->id)->get();
       // dd($guest->guest_name);
       // dd("booking id ".$this->booking_id);
        return view('livewire.guest.room-request-form',compact('guest','booking','accompanyingGuests'));
    }
}