<?php

namespace App\Livewire\Payment;

use App\Models\Booking;
use App\Models\Canteen;
use App\Models\RoomList;
use App\Models\CanteenPayment;
use Livewire\Component;

class GenerateCanteenBill extends Component
{
 public $bookingId;
    public function mount($bookingId){
        $this->bookingId = $bookingId;

    }
    public function render()
    {
      
        $booking  = Booking::where('booking_id', $this->bookingId)->first();
        $payment = CanteenPayment::where('booking_id', $this->bookingId)->first();  
      $rooms = RoomList::where('booking_id', $this->bookingId)->get();
        $canteenItems = collect(); // Default to empty collection
        $totalAmount = 0;
    
        if ($payment) {
            $canteenItems = Canteen::where('canteen_payment_id', $payment->id)->get();
            $totalAmount = $canteenItems->sum('total');
        }
     

        return view('livewire.payment.generate-canteen-bill', compact(
            'booking',
            'totalAmount',
            'payment',
            'canteenItems','rooms'
        ));
   
    }
}
