<?php

namespace App\Livewire\Payment;

use App\Models\Booking;
use App\Models\CanteenPayment;
use Livewire\Component;

class UpdateCanteenBill extends Component
{

    public $booking_id;
    public $payment_today;
      public function mount($bookingId){
          $this->booking_id = $bookingId;
  
      }
  
      public function updateBill(){
          $this->validate([
              'payment_today'=>'required|numeric',
  
          ]);
  
          $payment =  CanteenPayment::where('booking_id',$this->booking_id )->firstOrFail();
          $advance_amount = round($payment->advance + $this->payment_today); 
  
          $dueFlag= $this->setBalanceFlag2($advance_amount, $payment->total);
   /// dd($dueFlags);
  
  
    CanteenPayment::where('booking_id',$this->booking_id)->update([
          'due'=>$dueFlag,
          'advance'=> $advance_amount,
      ]);
    
      if($dueFlag=='cleared'){
          Booking::where('booking_id',$this->booking_id)->update([
              'follow_up'=>'no',
          ]);
      }
  
      return redirect(route('admin.generate_canteen_bill',['bookingId'=>$this->booking_id]));
      }
  
      private function setBalanceFlag2($advance, $total)
      {
         
          if ($advance > $total) {
              return "Return to Customer";
          } elseif ($advance == $total) {
              return "cleared";
          } else {
              return "not-cleared";
          }
      }
    public function render()
    {
        $booking = Booking::where('booking_id', $this->booking_id)->first();
        $payment = CanteenPayment::where('booking_id', $this->booking_id)->first();
        return view('livewire.payment.update-canteen-bill', compact('booking','payment'));
    }
}
