<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('guest_id')->constrained()->cascadeOnDelete();
            $table->string('purpose')->nullable();
            $table->text('purpose_details')->nullable();
            $table->string('payee')->nullable();
            $table->dateTime('booking_from')->nullable();
            $table->dateTime('booking_to')->nullable();
            $table->enum('floor_preference',['Ground Floor','First Floor','Second Floor','Third Floor'])->nullable();
            $table->string('canteen_preference')->nullable();
            $table->enum('booking_status',['draft','pending','accepted','rejected','checked_in','checked_out'])->default('draft');
            $table->string('booking_id',16)->nullable();
         
            $table->string('follow_up',16)->default('yes');
            $table->unsignedInteger('totalguests')->nullable();
            $table->unsignedInteger('num_days')->nullable();
            $table->unsignedInteger('num_rooms')->nullable();
            $table->string('comment')->nullable();
            $table->string('supporting_doc')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};
