<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('canteen_payments', function (Blueprint $table) {
            $table->id();
            $table->string('booking_id');
            $table->decimal('advance', 8, 2)->default(0);
            $table->decimal('total', 8, 2)->default(0);
            $table->string('due')->default('not-cleared');
                $table->string('payment_mode')->nullable();
            $table->string('transaction_reference')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('canteen_payments');
    }
};
