<div class="h-full w-full">
    <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->
    <div class="relative h-full flex-1 rounded-xl border border-gray-300 px-4 pb-4">
        <!-- Placeholder pattern (Ensure this doesn't overlap the form) -->
        <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15 z-0 pointer-events-none" />

        <div class="relative mb-0 p-4 w-full z-10">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl text-red-900">Change Booking Request </h1>
                    <flux:subheading size="lg" class="mb-2">{{ __(' Accept/Reject Booking  ') }}
                    </flux:subheading>
                </div>
                <div>
                    <img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}"
                        class="w-16 border-1 p-1 rounded-full border-gray-700" />
                </div>
            </div>
            <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
        </div><span class="text-xl text-red-800">Welcome Admin!</span> EDC Booking System
        <div class="mt-0 flex justify-end">


            <flux:button type="submit" variant="filled" class="ml-auto border border-gray-400" size="sm">Back to
                Profile</flux:button>
        </div>
      

        <d<div class="mt-3 w-full">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-2">
                <table class="w-full border">
                    <tr class="px-3 py-2 border">
                        <td class="px-3 py-2 border font-bold ml-3"><b>Applicant Name</b></td>
                        <td class="px-3 py-2 border">{{ ucwords($guest->user->name) }}</td>
                    </tr>
                    <tr class="px-3 py-2 border">
                        <td class="px-3 py-2 border font-bold ml-3">Guest Name</td>
                        <td class="px-3 py-2 border">{{ ucwords($guest->guest_name) }}</td>
                    </tr>
                    <tr class="px-3 py-2 border">
                        <td class="px-3 py-2 border font-bold ml-3">Booking Id Name</td>
                        <td class="px-3 py-2 border">{{ ucwords($booking->booking_id) }}</td>
                    </tr>
                    <tr class="px-3 py-2 border">
                        <td class="px-3 py-2 border font-bold ml-3">Purpose of Visit</td>
                        <td class="px-3 py-2 border">{{ ucwords($booking->purpose) }}</td>
                    </tr>
                    <tr class="px-3 py-2 border">
                        <td class="px-3 py-2 border font-bold ml-3">Details of Visit</td>
                        <td class="px-3 py-2 border">{{ ucwords($booking->purpose_details) }}</td>
                    </tr>
                    <tr class="px-3 py-2 border">
                        <td class="px-3 py-2 border font-bold ml-3">Booked On</td>
                        <td class="px-3 py-2 border">{{ ucwords($booking->created_at) }}</td>
                    </tr>
                    <tr class="px-3 py-2 border">
                        <td class="px-3 py-2 border font-bold ml-3">Booking From</td>
                        <td class="px-3 py-2 border">{{ date('d-M-Y H:i:s', strtotime($booking->booking_from)) }}</td>
                    </tr>
                    <tr class="px-3 py-2 border">
                        <td class="px-3 py-2 border font-bold ml-3">Booking To</td>
                        <td class="px-3 py-2 border">{{ date('d-M-Y H:i:s', strtotime($booking->booking_to)) }}</td>
                    </tr>
                    <tr class="px-3 py-2 border">
                        <td class="px-3 py-2 border font-bold ml-3">Rooms Required</td>
                        <td class="px-3 py-2 border">{{ str_pad($booking->num_rooms, 2, '0', STR_PAD_LEFT) }}</td>
                    </tr>
                    <tr class="px-3 py-2 border">
                        <td class="px-3 py-2 border font-bold ml-3">No. of days</td>
                        <td class="px-3 py-2 border">{{ str_pad($booking->num_days, 2, '0', STR_PAD_LEFT) }}</td>
                    </tr>
                </table>

                <div class="text-2xl text-red-950 my-auto">
                    Room Available: {{ env('TOTAL_ROOMS') - $sum }}
                    <div class="flex gap-2 w-full mt-4">
                        <!-- Accept Form -->
                        <form wire:submit.prevent="changeFromPendingToAccept({{ $booking->id }},'accepted')" wire:confirm="Are you sure you want to Accept this Booking?" class="w-full">
                            <flux:button variant="danger" type="submit" class="w-full" id="acceptButton">Accept</flux:button>
                        </form>
                    
                        <!-- Reject Form -->
                        <form wire:submit.prevent="changeFromPendingToAccept({{ $booking->id }}, 'rejected')" class="w-full">
                            <flux:button variant="primary" type="submit" class="w-full" id="rejectButton">Reject</flux:button>
                            
                           <!-- Dropdown for 'comment' should only be visible when status is 'rejected' -->
                            @if($status === 'rejected')
                                <div id="rejectDropdown" class="mt-4">
                                    <div class="text-sm">Choose Comment and Click Reject button again to change the status</div>
                                    <flux:select wire:model="comment" placeholder="Choose industry..." class="border border-gray-600" style="border: 1px solid black">
                                        <flux:select.option value="">Choose</flux:select.option>
                                        <flux:select.option>Not Available</flux:select.option>
                                        <flux:select.option>Book After 15 days</flux:select.option>
                                        <flux:select.option>Book After 1 week</flux:select.option>
                                        <flux:select.option>Under Maintenance</flux:select.option>
                                    </flux:select>
                                    <flux:error name="comment" />
                                    <x-custom.message />
                                </div>
                            @endif
                        </form>
                        
                    </div>

                   <!-- Dropdown (initially hidden) -->
        <div id="rejectDropdown" class="mt-4 hidden">
            <flux:select placeholder="Choose industry..." class="border border-gray-600" style="border: 1px solid black">
                <flux:select.option>Not Avialable</flux:select.option>
                <flux:select.option>Book After 15 days</flux:select.option>
                <flux:select.option>Book After 1 weeek</flux:select.option>
                <flux:select.option>Under Maintainance</flux:select.option>
              
            </flux:select>
        </div>
                </div>
            </div>

            <!-- -->
    </div>
</div>

</div>
<!-- JavaScript to toggle the display -->
<script>

    document.getElementById('rejectButton').addEventListener('click', function() {
        var dropdown = document.getElementById('rejectDropdown');
        // Toggle visibility
        dropdown.classList.toggle('hidden');
    });
    document.getElementById('acceptButton').addEventListener('click', function() {
        var dropdown = document.getElementById('rejectDropdown');
        // Toggle visibility
        dropdown.classList.add('hidden'); // Ensure the dropdown is hidden
    });
</script>
