

<div class="h-full w-full">
    <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->
    <div class="relative h-full flex-1 rounded-xl border border-gray-300 px-4 pb-4">
        <!-- Placeholder pattern (Ensure this doesn't overlap the form) -->
        <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15 z-0 pointer-events-none" />

        <div class="relative mb-0 p-4 w-full z-10">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl text-red-900">Search Room(s) Occupied</h1>
                    <flux:subheading size="lg" class="mb-2">{{ __(' Followup the Unpaid Bills  ') }}
                    </flux:subheading>
                </div>
                <div>
                    <img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}"
                        class="w-16 border-1 p-1 rounded-full border-gray-700" />
                </div>
            </div>
            <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
        </div><span class="text-xl text-red-800">Welcome Admin!</span> EDC Booking System
        <div class="mt-0 flex justify-end">


            <flux:button type="submit" variant="filled" class="ml-auto border border-gray-400" size="sm">Back to
                Profile</flux:button>
        </div>
        <x-custom.message />

        <div class="mt-3 w-full ">

            <div> 
                <section class="mt-0 ">
                    <div class="mx-autos max-w-screen-xl px-1 lg:px-2 ">
                        <!-- Start coding here -->
                        <div class="bg-white dark:bg-gray-800 relative shadow-md sm:rounded-lg overflow-hidden">
                            <form  wire:submit.prevent="NumOfRoomsOccupied" >
                            <div class=" p-4 border-2">
                                <div class="flex gap-4">
                                    <div class="">
                                        
                                        <input type="date" wire:model="time_from" name="time_from"
                                        min="{{ \Carbon\Carbon::today()->format('Y-m-d') }}"  class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full  p-2 "
                                            placeholder="Search" >
                                            <flux:error name="time_from" />
                                    </div>
                                    <div class="">
                                        
                                        <input type="date"  wire:model="time_to" name="time_to"
                                        min="{{ $time_from ?? \Carbon\Carbon::today()->format('Y-m-d') }}"  class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full  p-2 "
                                            placeholder="Search" >
                                            <flux:error name="time_to" />
                                    </div>
                                    <div><flux:button type="submit" variant="primary" class="mt-0">Search Num. of Rooms</flux:button></div>
                                
                                
                                </div>
                               <div class="mt-4"><span class="mt-4 text-sm bg-red-200 rounded-md px-2 py-1">
                                Total Number of Rooms Available From {{ $time_from ? \Carbon\Carbon::parse($time_from)->format('d-M-Y') : '____' }}  to {{ $time_to ? \Carbon\Carbon::parse($time_to)->format('d-M-Y') : '____' }}  : <b class="text-lg">{{$rooms_available}}</b></span></div>
                                
                            </div>
                            </form>
                            <div class="overflow-x-auto">
                                <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                                    <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                                        <tr>
                                            <th scope="col" class="px-3 py-2" wire:click="setSortBy('booking_id')">
                                                <x-custom.sortable_th name="booking_id" displayName="BOOKING ID"
                                                    sortBy="{{ $sortBy ?? '' }}" sortDir="{{ $sortDir ?? '' }}" />


                                            </th>
                                          
                                            <th scope="col" class="px-3 py-2">Booked On</th>
                                            <th scope="col" class="px-3 py-2" wire:click="setSortBy('booking_from')">

                                                <x-custom.sortable_th name="booking_from" displayName="BOOKING FROM"
                                                    sortBy="{{ $sortBy ?? '' }}" sortDir="{{ $sortDir ?? '' }}" />
                                            </th>
                                            <th scope="col" class="px-3 py-2" wire:click="setSortBy('booking_to')">
                                                <x-custom.sortable_th name="booking_to" displayName="BOOKING TO"
                                                    sortBy="{{ $sortBy ?? '' }}" sortDir="{{ $sortDir ?? '' }}" />
                                            </th>
                                          
                                           <th>Booked Room(s)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse ($bookings as $booking)
                                            <tr wire:key="{{ $booking->id }}" class="border-b dark:border-gray-700 ">
                                                <th scope="row"
                                                    class=" relative px-3 py-2 font-medium text-gray-900 whitespace-nowrap dark:text-white text-sm">

                                                    <flux:modal.trigger name="edit-profile">
                                                        <flux:button wire:click="openModal({{ $booking->id }})"
                                                            class="cursor-pointer" size="xs">
                                                            {{ $booking->booking_id }}
                                                        </flux:button>
                                                    </flux:modal.trigger>




                                                </th>
                                                       {{--   <td class="px-3 py-2 text-green-500 text-sm">
                                                {{ optional($booking->guest)->guest_name ?? 'N/A' }}ff</td> --}}
                                                <td class="px-3 py-2 text-sm">
                                                    {{ date_format($booking->created_at, 'd/M/y') }}</td>
                                                <td class="px-3 py-2  text-red-500 text-sm">
                                                    {{ date_format($booking->booking_from, 'd-M-Y H:i:s') }}


                                                </td>
                                                <td class="px-3 py-2  text-red-500 text-sm">
                                                    {{ date_format($booking->booking_to, 'd-M-Y H:i:s') }}


                                                </td>
                                                
                                              <td>{{ $booking->num_rooms }} 
                                            </td>

                                            </tr>
                                        @empty
                                        <tr><td colspan="4" class="text-center">Select the dates ( Booked From - Booked To) to find the Number of Room Vaccant </td></tr>
                                        @endforelse
                                    </tbody>
                                </table>

                            </div>
                            
                        </div>

                    </div>
                </section>

            </div>


       
        </div>

    </div>
    <!-- JavaScript to toggle the display -->
    <flux:modal name="edit-profile" class="w-full max-w-3xl ">
        <div class="space-y-6">
            <div>
                <h1 class="text-xl text-red-600">View Details of Applicant & Guest(s)</h1>

                @foreach ($bookings as $booking)
                    @if ($booking->id == $id)
                        <div wire:key="{{ $booking->id }}" class="grid grid-cols-2 gap-1  mt-6">
                            <div class=" space-y-3 ">
                                <b><u>Applicant's Details:</u></b><br />

                                <div><b>Name:</b> {{ $booking->user->name }}<br /></div>
                                <div><b>Designation:</b> {{ $booking->user->designation }}</div>
                                <div><b>Department: </b>{{ $booking->user->department }}</div>
                                <div><b>Email:</b> {{ $booking->user->email }}</div>
                                <div><b>Phone: </b> {{ $booking->user->phone }}</div>
                                <div><b>User Type: </b> {{ $booking->user->user_type }}</div>
                                <br>
                            </div>
                            <div class="border-l border-red-800 space-y-3 pl-2">
                                <b><u>Guest Details</u></b><br>
                                <div><b>Guest Name:</b> {{ $booking->guest->guest_name }}</div>
                                <div><b>Guest Email:</b> {{ $booking->guest->guest_email }}</div>
                                <div><b>Guest Address:</b> {{ $booking->guest->guest_phone }}</div>
                                <div><b>Guest State, City:</b> {{ $booking->guest->city }},
                                    {{ $booking->guest->state }}</div>
                                <div><b>Guest Relation:</b> {{ $booking->guest->guest_relation }}</div>
                                <div><b>Id Type Submitted: </b> {{ $booking->guest->guest_idtype }}</div>
                            </div>
                        </div>
                        <flux:spacer />
                        <div class=" mt-4 space-y-2 " style="margin-left: 40%">
                            <div class="text-xl text-dark "><b><u>Booking Details: </u></b></div>
                            <div><b>Booking Id: </b>{{ $booking->booking_id }}</div>
                            <div><b>Booking Purpose:</b> {{ $booking->purpose }}</div>
                            <div><b>Number of Rooms: </b>{{ $booking->num_rooms }}</div>
                            <div><b>Number of Days:</b> {{ $booking->num_days }}</div>
                            <div><b>Total Guests:</b> {{ $booking->totalguests }}</div>
                        </div>
                    @endif
                @endforeach
            </div>




            <div class="flex">



            </div>
        </div>
    </flux:modal>

