<div class="h-full w-full">
    <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->
    <div class="relative h-full flex-1 rounded-xl border border-gray-300 px-4 pb-4">
        <!-- Placeholder pattern (Ensure this doesn't overlap the form) -->
        <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15 z-0 pointer-events-none" />

        <div class="relative mb-0 p-4 w-full z-10">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl text-red-900">Assign Room(s) </h1>
                    <flux:subheading size="lg" class="mb-2">{{ __('You can Edit, Delete the guests & Book Room') }}
                    </flux:subheading>
                </div>
                <div>
                    <img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}"
                        class="w-16 border-1 p-1 rounded-full border-gray-700" />
                </div>
            </div>
            <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
        </div>
        <div class="mt-0 flex justify-end">

            <flux:button type="submit" variant="filled" class="ml-auto border border-gray-400" size="sm">Back to
                Profile</flux:button>
        </div>
        <x-custom.message />
        <div class="w-full">
            <div class="flex justify-between mt-4 mb-4">
                <div>
                    <div><b>Booking Ref. No.:</b> <span class="text-red-700"> {{ $rooms->booking_id }}</span></div>
                    <div><b>No. of Rooms Requested: </b> <span class="text-red-700"> {{ $rooms->num_rooms }}</span>
                    </div>
                </div>

                <div>
                    <div><b>Floor Preference :</b> {{ $rooms->floor_preference }}</div>
                    <div> <b>Number of days : </b> {{ $rooms->num_days }} </div>
                </div>
            </div>

            <div class="bg-amber-100 px-1">
                Number of rooms available for selection below is :
                <b class="text-red-700"> {{ $room_available_today }} </b>
                (Total available rooms may vary. To keep it correct, regularly check-out the expired bookings.)
            </div>
            <div class="flexs flexs-col md:flexs-row w-full gap-6">
                <!-- Room Buttons Section (Left Column) -->
                <div class="w-full md:w-3/4 mb-4">
                    <div class="grid grid-cols-1 gap-4">
                        @php
                            $floorRooms = [
                                'Ground' => 8,
                                'First' => 12,
                                'Second' => 7,
                                'Third' => 10,
                            ];
                            $roomCounter = 0;
                        @endphp

                        @foreach ($floorRooms as $floorName => $roomCount)
                            <div>
                                <h5 class="text-md font-semibold mt-8">{{ $floorName }} Floor:</h5>
                                <div
                                    class="grid grid-cols-6 lg:grid-cols-10 gap-2 border p-2 bg-gray-100 rounded-lg shadow-md">
                                    @for ($i = 1; $i <= $roomCount; $i++)
                                        @php
                                            $roomIndex = $roomCounter;
                                            $roomLabel = substr($floorName, 0, 1) . str_pad($i, 2, '0', STR_PAD_LEFT);
                                            $room = $total_rooms[$roomIndex] ?? null;
                                        @endphp

                                        <div class="flex flex-col items-center mb-4">
                                            <button type="button"
                                                class="room-btn w-3/4 aspect-square flex items-center justify-center 
                                                       bg-blue-500 text-white font-semibold rounded-lg shadow hover:bg-blue-700 
                                                       disabled:bg-gray-400 transition duration-200"
                                                value="{{ $roomIndex + 1 }}"
                                                {{ $room && $room->is_occupied === 'yes' ? 'disabled' : '' }}>
                                                {{ $roomLabel }}
                                            </button>

                                            <div class="flex gap-2 mt-2">
                                                <!-- Single -->
                                                <label class="flex items-center space-x-1 cursor-pointer">
                                                    <input type="radio" name="occupancy_{{ $roomIndex + 1 }}"
                                                        value="single" class="hidden"
                                                        {{ $room && $room->is_occupied === 'yes' ? 'disabled' : '' }}>
                                                    <div
                                                        class="w-6 h-6 flex items-center justify-center rounded-full shadow-md hover:bg-gray-300">
                                                        <img src="https://cdn-icons-png.flaticon.com/128/1077/1077114.png"
                                                            class="w-4 h-4" alt="Single User">
                                                    </div>
                                                </label>

                                                <!-- Double -->
                                                <label class="flex items-center space-x-1 cursor-pointer">
                                                    <input type="radio" name="occupancy_{{ $roomIndex + 1 }}"
                                                        value="double" class="hidden"
                                                        {{ $room && $room->is_occupied === 'yes' ? 'disabled' : '' }}>
                                                    <div
                                                        class="w-6 h-6 flex items-center justify-center 
                                                                {{ $room && $room->type === 'double' ? 'bg-red-500' : 'bg-gray-200' }} 
                                                                rounded-full shadow-md hover:bg-gray-300">
                                                        <flux:icon.users class="size-5" />
                                                    </div>
                                                </label>
                                            </div>
                                        </div>

                                        @php $roomCounter++; @endphp
                                    @endfor
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Reset + Submit Form Section (Right Column) -->
                <div class="w-full  flex flex-row items-start gap-4 mt-12 md:mt-0">
                    <!-- Reset Button -->
                    <button id="reset-btn" 
                            class="px-4 py-3 bg-red-500 text-white font-bold rounded-lg shadow 
                                   hover:bg-red-700 h-fit my-auto mt-5">
                        Reset
                    </button>
                
                    <!-- Horizontal Form -->
                    <form wire:submit.prevent="store" class="flex flex-row items-start gap-4 w-full">
                        <flux:input 
                            wire:model="occupancy_array" 
                            label="Occupancy" 
                            id="occupancy_array" 
                            class="w-full" 
                        />
                
                        <flux:input 
                            wire:model="rooms_array" 
                            label="Rooms" 
                            id="rooms_array" 
                            class="w-full" 
                        />
                
                        <flux:input 
                            wire:model="advance" 
                            type="currency" 
                            icon="indian-rupees" 
                            label="Advance" 
                            id="advance_field" 
                            class="border border-gray-700 w-full" 
                            value="0" 
                        />
                
                        <flux:button 
                            type="submit" 
                            variant="primary" 
                            class="bg-gray-600 px-4 py-2 h-fit  mt-5">
                            Submit
                        </flux:button>
                    </form>
                </div>
                
                
            </div>

        </div>
    </div>


<br><br><br>

</div>
<!-- JavaScript to toggle the display -->


<script>
    document.addEventListener("DOMContentLoaded", function () {
        const buttons = document.querySelectorAll(".room-btn");
        const resetButton = document.getElementById("reset-btn");
        const roomsArrayInput = document.getElementById("rooms_array");
        const occupancyArrayInput = document.getElementById("occupancy_array");

        const MAX_ROOMS = 3;
        let selectedRooms = [];
        let occupancyData = {};
        let selectedLabels = [];

        function updateInputs() {
            roomsArrayInput.value = JSON.stringify(selectedRooms);
            occupancyArrayInput.value = JSON.stringify(occupancyData);
            roomsArrayInput.dispatchEvent(new Event("input"));
            occupancyArrayInput.dispatchEvent(new Event("input"));
        }

        function disableUnselectedButtons() {
            buttons.forEach(button => {
                if (!selectedRooms.includes(button.value)) {
                    button.disabled = true;
                    button.style.opacity = "0.5";
                    button.style.cursor = "not-allowed";
                }
            });
        }

        function enableAllButtons() {
            buttons.forEach(button => {
                button.disabled = false;
                button.style.opacity = "1";
                button.style.cursor = "pointer";
            });
        }

        // Handle Room Selection
        buttons.forEach(button => {
            button.addEventListener("click", function () {
                const roomIndex = this.value;
                const label = this.textContent;

                if (selectedRooms.includes(roomIndex)) return;

                if (selectedRooms.length >= MAX_ROOMS) {
                    alert("You can only select up to 3 rooms.");
                    disableUnselectedButtons();
                    return;
                }

                selectedRooms.push(roomIndex);
                selectedLabels.push(label);
                occupancyData[roomIndex] = "double";

                this.style.textDecoration = "line-through";
                this.style.background = "#3cb371";
                this.classList.add("bg-green-500");

                const selectedRoomsString = selectedLabels.map(label => label.trim()).join(", ");
                alert("You have selected: " + selectedRoomsString);

                if (selectedRooms.length >= MAX_ROOMS) {
                    disableUnselectedButtons();
                }

                updateInputs();
            });
        });

        // Handle Occupancy Selection
        document.querySelectorAll("input[type='radio']").forEach(radio => {
            radio.addEventListener("change", function () {
                const roomIndex = this.name.split("_")[1];

                if (selectedRooms.includes(roomIndex)) {
                    occupancyData[roomIndex] = this.value;

                    document.querySelectorAll(`input[name="occupancy_${roomIndex}"]`).forEach(r => {
                        r.parentElement.style.background = "#E5E4E2";
                    });

                    this.parentElement.style.background = "green";
                    alert('You have chosen ' + occupancyData[roomIndex] + ' Occupancy for this Room');
                    updateInputs();
                } else {
                    alert('Kindly select the room first.');
                }
            });
        });

        // Reset Button Click
       document.getElementById("reset-btn").addEventListener("click", function () {
    window.location.href = window.location.href;
});
    });
</script>
