<div class="h-full w-full">
    <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->
    <div class="relative h-full flex-1 rounded-xl border border-gray-300 px-4 pb-4">
        <!-- Placeholder pattern (Ensure this doesn't overlap the form) -->
        <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15 z-0 pointer-events-none" />

        <div class="relative mb-3 p-4 w-full z-10">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl text-red-900">Edit Main Guest </h1>
                    <flux:subheading size="lg" class="mb-2">{{ __('Add the details of main guest') }}
                    </flux:subheading>
                </div>
                <div>
                    <img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}"
                        class="w-16 border-1 p-1 rounded-full border-gray-700" />
                </div>
            </div>
            <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
        </div>

        <div class="w-full mx-auto">
            
            <form wire:submit.prevent="update" class="space-y-4 z-20 relative grid grid-cols-1 sm:grid-cols-2 gap-4"
                enctype="multipart/form-data">

                <!-- First column -->
                <div class="my-auto">
                    <flux:field>
                        <flux:label>Full Name of Guest</flux:label>
                        <flux:input wire:model="guest_name" type="text" placeholder="Full Name of Guest" />
                        <flux:error name="guest_name" />
                    </flux:field>
                </div>

                <flux:field>
                    <flux:textarea wire:model="address" rows="3" label="Address"
                        placeholder="Enter your Complete Address of the Guest" />
                </flux:field>

                <!-- Second column -->
                <div>
                    <flux:field>
                        <flux:label>City</flux:label>
                        <flux:input wire:model="city" type="text" placeholder="City" />
                        <flux:error name="city" />
                    </flux:field>
                </div>

                <div>
                    <flux:label>Choose your state</flux:label>
                    <flux:select wire:model="state" >
                        <flux:select.option value="" selected>Choose State</flux:select.option>
                        @foreach (config('helpers.states_all') as $value)
                            <flux:select.option>{{ $value }}</flux:select.option>
                        @endforeach
                    </flux:select>
                    <flux:error name="state" />
                </div>

                <!-- 3rd row for User Type -->
                <div>
                    <flux:field>
                        <flux:label>Mobile No.</flux:label>
                        <flux:input wire:model="guest_phone" type="text" placeholder="Enter 10 digit Mobile No." />
                        <flux:error name="guest_phone" />
                    </flux:field>
                </div>

                <div>
                    <flux:field>
                        <flux:label>Guest Email (optional)</flux:label>
                        <flux:input wire:model="guest_email" type="email" placeholder="Email of the Guest" />
                        <flux:error name="guest_email" />
                    </flux:field>
                </div>

                <!-- Conditional Designation or Course -->
                <div>
                    <flux:label> Gender</flux:label>
                    <flux:select wire:model="guest_gender" >
                        <flux:select.option value="" selected>Choose Gender</flux:select.option>
                        <flux:select.option>Male</flux:select.option>
                        <flux:select.option>Female</flux:select.option>
                        <flux:select.option>Prefer Not to Say</flux:select.option>
                    </flux:select>
                    <flux:error name="guest_gender" />
                </div>

                <div>
                    <flux:label>Relationship with guest</flux:label>
                    <flux:select wire:model="guest_relation" >
                        <flux:select.option value="" selected>Choose Relationship</flux:select.option>
                        <flux:select.option>A. Institute Guest</flux:select.option>
                        <flux:select.option>B. Departmental Guest</flux:select.option>
                        <flux:select.option>C. Close Relative of Employee</flux:select.option>
                        <flux:select.option>D. All Other than A, B & C</flux:select.option>
                    </flux:select>
                    <flux:error name="guest_relation" />
                </div>

                <!-- Profile Picture Upload -->
                <div>
                    <flux:label>Guest's ID</flux:label>
                    <flux:select wire:model="guest_idtype" id="guest_idtype"  >
                        <flux:select.option value="" selected>Choose Guest's Id type</flux:select.option>   
                        <flux:select.option>Aadhar</flux:select.option>
                        <flux:select.option>Passport</flux:select.option>
                        <flux:select.option>Pan Card</flux:select.option>
                        <flux:select.option>VoterId</flux:select.option>
                        <flux:select.option>Driving Licence No.</flux:select.option>
                        <flux:select.option>{{ trim('Will Provide during Check-In') }}</flux:select.option>
                    </flux:select>
                    <flux:error name="guest_idtype" />
                </div>
        
                <!-- Conditionally show ID Number input or text message -->
                <div id="idno-field" style="{{ $guest_idtype === 'Not Available' ? 'display: none;' : 'display: block;' }}">
                    <flux:field>
                        <flux:label>Id Number</flux:label>
                        <flux:input wire:model="guest_idno" type="text" placeholder="Id Number" />
                        <flux:error name="guest_idno" />
                    </flux:field>
                    <p class="text-sm text-red-600">To be provided at the time of check-in.</p>
                </div>
        
                <!-- Message when 'Unknown' is selected -->
                <div id="idno-message" style="{{ $guest_idtype === 'Not Available' ? 'display: block;' : 'display: none;' }}">
                    <p class="text-red-700 mt-4">You have not submitted the Id Number<br/>
                        Please ensure to provide the ID at the time of check-in.</p>
                </div>

                <!-- Submit Button -->
                <flux:button type="submit" variant="primary" class="mt-6">Update Guest</flux:button>
            </form>
        </div>
    </div>
</div>

<!-- JavaScript to toggle the display -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        setTimeout(function () {
            const guestIdTypeSelect = document.getElementById('guest_idtype');
            const idnoField = document.getElementById('idno-field');
            const idnoMessage = document.getElementById('idno-message');

            function toggleIdNoField() {
                const selectedValue = guestIdTypeSelect.value;
                if (selectedValue === 'Will Provide during Check-In') {
                    idnoField.style.display = 'none';
                    idnoMessage.style.display = 'block';
                } else {
                    idnoField.style.display = 'block';
                    idnoMessage.style.display = 'none';
                }
            }

            toggleIdNoField();

            guestIdTypeSelect.addEventListener('change', function () {
                toggleIdNoField();
               // @this.set('guest_idtype', guestIdTypeSelect.value); // Sync with Livewire
            });
        }, 500);
    });
</script>
