<div class="h-full w-full">
    <style>
        @keyframes blinker {
            50% {
                opacity: 0;
                color: #f87171;
            }
        }
    </style>
    <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->
    <div class="relative h-full flex-1 rounded-xl border border-gray-300 px-4 pb-4 z-10">
        <!-- Placeholder pattern (Ensure this doesn't overlap the form) -->
        <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15 z-0 pointer-events-none" />

        <div class="relative mb-3 p-4 w-full z-10">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl text-red-900">Room Request Form </h1>
                    <flux:subheading size="lg" class="mb-2">{{ __('Add the details of main guest') }}
                    </flux:subheading>
                </div>
                <div>
                    <img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}"
                        class="w-16 border-1 p-1 rounded-full border-gray-700" />
                </div>
            </div>
            <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
            <div class="bg-red-50 px-2 p-1" style="animation: blinker 3s linear infinite;"> Take a printout of this
                form, get it approved by the appropriate authority, and upload it to continue the booking process.</div>

        </div>
      
            <div class="flex  items-center justify-around ">
               <div><a wire:navigation href="/guests/upload/allocation_form/{{ $booking->booking_id }}" 
                class="bg-gray-800 hover:bg-gray-200 p-2 rounded-lg" style="background:maroon;color:white">Upload Room Allotment  Form</a></div>
                <div> <a class="btn btn-primary form-control px-2 py-2 rounded-lg text-sm bg-gray-500
               text-white hover:text-black hover:bg-amber-200"
                        href="javascript:void(0);" onclick="printPageArea('printableArea')">Print Allotment Form 🖨</a></div>
            </div>
            <div id="printableArea">
                <style>
                    @media print {
                        body {
                            -webkit-print-color-adjust: exact !important;
                            /* Chrome/Safari */
                            print-color-adjust: exact !important;
                            /* Firefox */
                        }
                    }
                </style>
                <div class="w-full mx-auto">
                    <div class="max-w-4xl mx-auto p-6 bg-white shadow rounded">

                        <img src="{{ asset('images/header_allotment_form.png') }}" class="border "
                            style="height: 200px;width:100%" />
                        <table class="border-collapse border border-gray-400 w-full text-sm " style="font-size:12px;">
                            <tbody>
                                <tr>
                                    <td class="border border-gray-300 p-1">आवेदक का नाम / Name of applicant </td>
                                    <td class="border border-gray-300 p-1">{{ auth()->user()->name }}</td>
                                </tr>
                                <tr>
                                    <td class="border border-gray-300 p-1">पद एवं विभाग / Designation & Department </td>
                                    <td class="border border-gray-300 p-1">{{ auth()->user()->designation }}
                                        ({{ auth()->user()->department }})</td>
                                </tr>
                                <tr>
                                    <td class="border border-gray-300 p-1">कर्मचारी सं0 / Employee Code</td>
                                    <td class="border border-gray-300 p-1">{{ auth()->user()->unique_id }}</td>
                                </tr>
                                <tr>
                                    <td class="border border-gray-300 p-1">पता एवं फ़ोन नं0 / Address & Phone No.</td>
                                    <td class="border border-gray-300 p-1">{{ auth()->user()->address }} &nbsp; -
                                        &nbsp;{{ auth()->user()->phone }} </td>
                                </tr>
                                <tr>
                                    <td class="border border-gray-300 p-1">अतिथि का नाम / Name of Guest</td>
                                    <td class="border border-gray-300 p-1">{{ $booking->guest->guest_name }}</td>
                                </tr>
                                <tr>
                                    <td class="border border-gray-300 p-1">अतिथि का पता / Address of Guest</td>
                                    <td class="border border-gray-300 p-1">{{ $booking->guest->address }}</td>
                                </tr>
                                <tr>
                                    <td class="border border-gray-300 p-1">अतिथि का मोबाइल नं0 एवं इ.मेल / Mobile No. &
                                        Email of Guest</td>
                                    <td class="border border-gray-300 p-1">{{ $booking->guest->guest_phone }} &nbsp; &nbsp;
                                        &nbsp;{{ $guest->guest_email }}</td>
                                </tr>
                                <tr>
                                    <td class="border border-gray-300 p-1">अतिथि का आवेदक से सम्बंध / Relation with
                                        Applicant

                                        <div class=""> A (Institute Guest), B (Departmental
                                            Guest),<br> C (Close Relatives of Faculty/Staff
                                            only) <br>& D (All other than A, B & C)</div>
                                    </td>
                                    <td class="border border-gray-300 p-1">{{ $booking->guest->guest_relation }}</td>
                                </tr>
                                <tr>
                                    <td class="border border-gray-300 p-1">साथ में आये व्यक्तियों का नाम एवं अतिथि से
                                        सम्बन्ध /<br> Accompanying Persons & Relation</td>
                                    <td class="border border-gray-300 p-1">
                                     

                                        @foreach ($accompanyingGuests as $accompanyingGuest)
                                            <div><span class="me-2">{{ $loop->iteration . '.' }}</span><span
                                                    class="me-5">
                                                    {{ 'Name: ' . $accompanyingGuest->accompaying_name }} </span>
                                                {{ 'Relation: ' . $accompanyingGuest->accompaying_relation }} </div>
                                        @endforeach
                                    </td>
                                </tr>
                                <tr>
                                    <td class="border border-gray-300 p-1">किराया भुगतान (आवेदक/अतिथि) द्वारा/<br> Rent
                                        Paid
                                        by
                                        (Applicant/Guest)</td>
                                    <td class="border border-gray-300 p-1">{{ $booking->payee }}</td>
                                </tr>
                                <tr>
                                    <td class="border border-gray-300 p-1">आने की तिथि एवं समय / Check-in Date & Time
                                    </td>
                                    <td class="border border-gray-300 p-1">
                                        {{ date('d-M-Y', strtotime($booking->booking_from)) }}</td>
                                </tr>
                                <tr>
                                    <td class="border border-gray-300 p-1">जाने की तिथि एवं समय / Check-out Date & Time
                                    </td>
                                    <td class="border border-gray-300 p-1">
                                        {{ date('d-M-Y', strtotime($booking->booking_to)) }}
                                    </td>
                                </tr>
                                <tr>
                                    <td class="border border-gray-300 p-1">दिनों की संख्या/ Number of Days</td>
                                    <td class="border border-gray-300 p-1">
                                        {{ str_pad($booking->num_days, 2, '0', STR_PAD_LEFT) }}
                                    </td>
                                </tr>
                                <tr>
                                    <td class="border border-gray-300 p-1">कमरों की संख्या / umber of Rooms Required
                                    </td>
                                    <td class="border border-gray-300 p-1">
                                        {{ str_pad($booking->num_rooms, 2, '0', STR_PAD_LEFT) }}</td>
                                </tr>
                                <tr>
                                    <td class="border border-gray-300 p-1">रुकने का उद्देश्य (व्यक्तिगत/शासकीय) /
                                        Purpose of Stay</td>
                                    <td class="border border-gray-300 p-1">{{ ucwords($booking->purpose) }}</td>
                                </tr>

                                <tr>
                                    <td class="border border-gray-300 pl-10 pt-6">तिथि / Date: ____________________<br>
                                        समय/Place: ___________________</td>
                                    <td class="border border-gray-300 pl-1 pt-6">आवेदक के हस्ताक्षर / Signature of
                                        Applicant</td>
                                </tr>

                                <tr class="text-xs">
                                    <td class="border border-gray-300 pl-10 pt-3">
                                        Forwarded By:
                                        <ul class="list-disc">
                                            <li>शासकीय बुिकंग के लिए कुलसचिव/विभागाध्यक्ष / अध्यक्ष छात्र गतिविधि केन्द
                                                /<br> Registrar/HOD/President SAC for Official Booking</li>
                                            <li>
                                                छात्र की व्यक्तिगत बुिकंग के लिए छात्रावास वार्डन / Warden In-Charge
                                                <br>for Students Personal Booking</li>
                                    </td>
                                    <td class="border border-gray-300 pl-10 pt-10"></td>
                                </tr>
                                <tr>
                                    <td colspan="2" class="text-center pl-10 pt-2"><b>कार्यालय प्रयोग हेतु (For
                                            Office Use)</b></td>

                                </tr>
                                <tr>
                                    <td class=" pl-10 pt-6">आवंटित कमरा नं0 (Room No. Allotted):
                                    </td>
                                    <td class=" pl-10 pt-6">द्वारा (By) </td>
                                </tr>
                                <tr>
                                    <td class=" pl-10 pt-6">केयर टेकर (Care Taker):
                                    </td>
                                    <td class=" pl-10 pt-6"> प्रभारी अधिकारी (Officer In-charge) </td>
                                </tr>
                            </tbody>
                        </table>



                    </div>
                </div>
            </div>
            <!-- JavaScript to toggle the display -->
            <script>
                function printPageArea(areaID) {
                    var printContent = document.getElementById(areaID).innerHTML;
                    var originalContent = document.body.innerHTML;

                    document.body.innerHTML = printContent;
                    window.print();
                    document.body.innerHTML = originalContent;
                    location.reload(); // Optional: reload to restore original state with JS working again
                }
            </script>
