<div class="h-full w-full">
    <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->
    <div class="relative h-full flex-1 rounded-xl border border-gray-300 px-4 pb-4">
        <!-- Placeholder pattern (Ensure this doesn't overlap the form) -->
        <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15 z-0 pointer-events-none" />

        <div class="relative mb-0 p-4 w-full z-10">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl text-red-900">Upload Allotment Request Form</h1>
                    <flux:subheading size="lg" class="mb-2">{{ __('Forwarded by Concern Official') }}
                    </flux:subheading>
                </div>
                <div>
                    <img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}"
                        class="w-16 border-1 p-1 rounded-full border-gray-700" />
                </div>
            </div>
            <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
        </div>
        <div class="mt-0 flex justify-end">

            <flux:button type="submit" variant="filled" class="ml-auto border border-gray-400" size="sm">Back to
                Profile</flux:button>
        </div>
        <x-custom.message />
        <div class="mt-3 w-full f">
            <div class="bg-red-100 my-auto text-sm px-2"> Once submitted, your request will be in queue (pending )state. It will be verified by the Admin, 
                and you will be notified once the booking status is updated. All official bookings will need prior approval of the Director/Registrar or Head of the Department/Section. </div>
               
          <div class="mx-auto flex justify-center mt-12">   
            <form  wire:submit="save">
          
                <flux:input type="file" size="sm" wire:model="supporting_doc"
                label="Room Allocation Form (Allowed formats: pdf, jpeg, jpg, png under 1MB)" />
    
            @if ($supporting_doc)
                @php
                    $ext = strtolower($supporting_doc->getClientOriginalExtension());
                @endphp
    
                @if (in_array($ext, ['jpeg', 'jpg', 'png', 'gif']))
                    <img src="{{ $supporting_doc->temporaryUrl() }}"
                        class="h-16 w-16 object-cover rounded-full mt-2" />
                @elseif ($ext === 'pdf')
                    <div class="flex flex-col items-center space-y-2 mt-2">
                        <span class="text-gray-700">PDF File Selected</span>
                    </div>
                @else
                    <span class="text-red-500 mt-2 block">Invalid file type. Please upload an image or PDF.</span>
                @endif
            @endif
            <flux:button type="submit" class="mt-3" variant="primary">Submit</flux:button>
 
                    
          </form>
        </div>
               
        </div>


    </div>
</div>
