<div class="h-full w-full">
    <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->
    <div class="relative h-full flex-1 rounded-xl border border-gray-300 px-4 pb-4">
        <!-- Placeholder pattern (Ensure this doesn't overlap the form) -->
        <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15 z-0 pointer-events-none" />
      
        
        <div class="relative mb-0 p-4 w-full z-10">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl text-red-900">Bill / Invoice </h1>
                    <flux:subheading size="lg" class="mb-2">{{ __('You can Edit, Delete the guests & Book Room') }}
                    </flux:subheading>
                </div>
                <div>
                    <img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}"
                        class="w-16 border-1 p-1 rounded-full border-gray-700" />
                </div>
            </div>
            <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
        </div>
        <div class="mt-0 flex justify-end">
 <div>
  <flux:button type="button" wire:navigate href="{{ route('admin.update_bill',$booking->booking_id) }}"  variant="primary" class="ml-auto border border-gray-400 bg-red-900" size="sm">Update Amount
  </flux:button>
 
 @if(($booking->guest->guest_relation!='A. Institute Guest'))
 @if (isset($canteenItems) && $canteenItems->isNotEmpty())
                                                    <flux:button
                                                        href="/admin/generate_canteen_bill/{{ $booking->booking_id }}"
                                                        variant="primary" size="sm"
                                                        class="bg-amber-200 text-black hover:text-white p-2 ">
                                                        {{ 'Canteen Bill' }}
                                                    </flux:button>
                                                @else
                                                    <flux:button variant="primary" size="sm" disabled
                                                        class="bg-zinc-300 text-gray-600 line-through">
                                                        {{ 'Canteen Bill' }}
                                                    </flux:button>
                                                @endif
  <flux:button wire:navigate href="{{ route('admin.create.canteen',$booking->booking_id) }}" variant="primary" class="ml-auto border border-gray-400 bg-green-900" size="sm">Add Canteen Charges 
  </flux:button> @endif 
  <a class="btn btn-primary form-control px-2 py-2 rounded-lg text-sm bg-gray-500
  text-white hover:text-black hover:bg-amber-200" href="javascript:void(0);"
 onclick="printPageArea('printableArea')">Print Invoice 🖨</a></div>
        </div>
        <link href="https://cdn.jsdelivr.net/npm/tailwindcss@3.0.24/dist/tailwind.min.css" rel="stylesheet">
        <x-custom.message />
        <div id="printableArea">

            <style>
                @media print {
                    body {
                        -webkit-print-color-adjust: exact !important; /* Chrome/Safari */
                        print-color-adjust: exact !important;         /* Firefox */
                    }
                }
            </style>

            <h1 class="text-xl underline">INVOICE</h1>
            <div class="flex justify-between border-b border-t border-gray-600 py-4 px-1">
                <div>
                    <div>Executive Development Center</div>
                    <div>Motilal Nehru National Institute of Technology Allahabad, Prayagraj (MNNIT)</div>
                </div>


                <div>Date : {{ date('d/M/Y H:i:s') }}
                    <div>Booking Id : {{ $bookingId }}</div>
                </div>


            </div>
            <div style="background: #FAD5A5; !important">
                <table width="100%">
                    <tbody>
                        <tr>
                            <td style="width:30%">Booked By : {{ $booking->user->name }}</td>
                            <td style="width:38%">Department : {{ $booking->user->department }}</td>
                            <td style="width:25%">Desig. / Course : {{ $booking->user->designation }}</td>
                    </tbody>
                </table>

            </div>
            <!-- Guest Information Table -->
            <div style="overflow-x: auto;">
                <table style="width:100%; border-collapse: collapse; border: 1px solid #D1D5DB;">
                    <tbody>
                        <tr style="border-bottom: 1px solid #D1D5DB;">
                            <td style="padding: 0.5rem; "><span style="font-weight: bold;">Guest: </span> {{ ucwords(strtolower($booking->guest->guest_name)) }}</span></td>
                            <td style="padding: 0.5rem; "><span style="font-weight: bold;">From:</span> {{ date('d/M/Y', strtotime($booking->booking_from)) }}</td>
                          <td style="padding: 0.5rem;  "><span style="font-weight: bold;"> Purpose:</span>{{ ucwords($booking->purpose) }}</td> 
                          <td style="padding: 0.5rem;  "><span style="font-weight: bold;">Rooms:</span>{{ str_pad($booking->num_rooms, 2, '0', STR_PAD_LEFT) }}</td> 
                          <td style="padding: 0.5rem;  "><span style="font-weight: bold;">Days:</span>{{ str_pad($booking->num_days, 2, '0', STR_PAD_LEFT) }}</td> 
                          <td style="padding: 0.5rem;  "><span style="font-weight: bold;">Total Guest(s):</span>{{ str_pad($booking->totalguests, 2, '0', STR_PAD_LEFT) }}</td>  
                        </tr>
                        <tr> <td colspan="6" style="padding: 0.5rem; "><span style="font-weight: bold;">List of Rooms Booked:&nbsp;&nbsp;  
                            @forelse ( $rooms as $room )
                            <span class="text-red-800 mx-2"> {{$room->room->room_name  }} @if (!$loop->last),@endif</span>
                            
                        @empty
                            No Room Number Found
                        @endforelse</td></tr>
                        
                      
                    </tbody>
                </table>
            </div>

            <!-- Payment Status -->
            <div class="flex justify-between mt-4  gap-2 text-right">
                <span class="bg-yellow-300 px-2 py-1 text-sm font-bold mr-2">
                    Category: {{ ucfirst($booking->guest->guest_relation) }}
                </span>
                <span class="bg-yellow-300 px-2 py-1 text-sm font-bold">
                    Payment Status: {{ ucfirst($payment->due) }}
                </span>
               @php
                 $letter = explode('.', $booking->guest->guest_relation)[0];
               @endphp
            </div>

            <!-- Charges Table -->
            <div class="overflow-x-auto mt-4">
                <table class="w-full border-collapse border border-gray-300">
                    <thead>
                        <tr class="border-b-2 border-black">
                            <th class="p-2 text-left"><u>Description</u></th>
                            <th class="p-2 text-right"><u>Total</u></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="border-b border-gray-300">
                            <td class="p-2">
                               
                                Basic Stay Charges (No. of Rooms × No. of Days) = {{ $booking->num_rooms }} ×
                                {{ $booking->num_days }} <br>
                                <table>
                                   @if( $rooms_single >0) <tr><td> Sinlge Occupancy Amount X No. of Rooms X No. days ({{ env("ROOM_RENT_CAT_{$letter}_SINGLE") }} X {{ $rooms_single }} X {{ $booking->num_days }})  <td> = </td><td>{{ env("ROOM_RENT_CAT_{$letter}_SINGLE")*$rooms_single*$booking->num_days  }}</td>  </tr>@endif
                                   @if( $rooms_double >0) <tr><td class="text-center">Double Occupancy Amount X No. of Rooms X  No. days ({{ env("ROOM_RENT_CAT_{$letter}_DOUBLE") }} X {{ $rooms_double }} X {{ $booking->num_days }} ) </td> <td> = </td><td>{{ env("ROOM_RENT_CAT_{$letter}_DOUBLE")*$rooms_double*$booking->num_days  }}</td> </tr> @endif
                                </table>
                                 
                            </td>
                            <td class="p-2 text-right">{{ number_format($payment->total_room_amount, 2) }}</td>
                        </tr>
                       {{--  <tr class="border-b border-gray-300">
                            <td class="p-2">Canteen Charges</td>
                            <td class="p-2 text-right">{{ number_format($payment->canteen, 2) }}ss</td>
                        </tr>--}} 
                        @php
                            $gst_rate = 0;
                            $gst_room = 0;
                            if ($booking->purpose == 'non official') {
                                $gst_rate = env('GST') * 100 - 100;
                                $gst_room = ($payment->room * $gst_rate) / 100;
                            }
                        @endphp
                        <tr class="border-b border-gray-300">
                            <td class="p-2">{{--GST @ {{ $gst_rate }}% on stay charges--}}</td>
                            <td class="p-2 text-right">{{-- number_format($gst_room, 2) --}}</td>
                        </tr>
                        <tr class="border-b border-gray-300">
                            <td class="p-2  font-bold">
                                Total Charges (Basic Stay Charge{{-- + GST on Room--}})
                            </td>
                            <td class="p-2 text-right text-blue-500 font-bold">
                                {{ number_format(round($payment->total), 2) }}
                            </td>
                        </tr>
                        <tr class="border-b border-gray-300">
                            <td class="p-2  font-bold">Advance Payment made by Customer</td>
                            <td class="p-2 text-right">{{ number_format($payment->advance, 2) }}</td>
                        </tr>
                        <tr class="bg-blue-100">
                            <td class="p-2  font-bold">
                                Balance Amount (Total Amount - Advance Payment)
                            </td>
                            <td class="p-2 text-right text-red-500 font-bold">
                                {{ number_format(round($payment->total - $payment->advance), 2) }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>


            <br>
            <div class="row "><b>THANK YOU !</b></div>

            <hr>
            <div class="row "><b>Payment Mode :</b> {{$payment->payment_mode}}  {!! ($payment->payment_mode!='Cash')? ' <b>Transaction Id /Ref. No:</b> '.$payment->transaction_reference :''!!}</div>
            <br>
            <br><br><br><br>
            <table width="100%">
                <tr>
                    <td width="77%">Cutomer Signature</td>
                    <td width="23%" align="right">EDC Seal & Signature</td>
                </tr>
            </table>



           
        </div>
        <div class="row justify-content-center mt-3">
            <div class="col-md-4 ">
                <a class="btn btn-primary form-control px-2 py-2 rounded-lg text-sm bg-gray-500
                 text-white hover:text-black hover:bg-amber-200" href="javascript:void(0);"
                onclick="printPageArea('printableArea')">Print Invoice 🖨</a>
            </div>
        </div>
    </div>
</div>

<script>
    function printPageArea(areaID) {
        var printContent = document.getElementById(areaID).innerHTML;
        var originalContent = document.body.innerHTML;

        document.body.innerHTML = printContent;
        window.print();
        document.body.innerHTML = originalContent;
        location.reload(); // Optional: reload to restore original state with JS working again
    }
</script>