<div class="h-full w-full">
    <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->
    <div class="relative h-full flex-1 rounded-xl border border-gray-300 px-4 pb-4">
        <!-- Placeholder pattern (Ensure this doesn't overlap the form) -->
        <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15 z-0 pointer-events-none" />
      
        
        <div class="relative mb-0 p-4 w-full z-10">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl text-red-900">Update Canteen Invoice </h1>
                    <flux:subheading size="lg" class="mb-2">{{ __('You can Edit, Delete the guests & Book Room') }}
                    </flux:subheading>
                </div>
                <div>
                    <img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}"
                        class="w-16 border-1 p-1 rounded-full border-gray-700" />
                </div>
            </div>
            <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
        </div>
        <div class="mt-0 flex justify-end">
 <div>
  <flux:button type="button" wire:navigate href="{{ route('admin.update_bill',$booking->booking_id) }}"  variant="primary" class="ml-auto border border-gray-400 bg-red-900" size="sm">Update Amount
  </flux:button>
 
            </div>
        </div>
       
        <x-custom.message />
        <div id="printableArea">



            <h1 class="text-xl underline">Update Invoice </h1>
            
            <div style="background: #FAD5A5; !important">
                <table width="100%">
                    <tbody>
                        <tr>
                            <td style="width:30%">Booked By : {{ $booking->user->name }}</td>
                            <td style="width:38%">Department : {{ $booking->user->department }}</td>
                            <td style="width:25%">Desig. / Course : {{ $booking->user->designation }}</td>
                    </tbody>
                </table>

            </div>
            <!-- Guest Information Table -->
            <div style="overflow-x: auto;">
                <table   class="w-full" style="border-collapse: collapse; border: 1px solid #D1D5DB;">
                    <tbody>
                        <tr style="border-bottom: 1px solid #D1D5DB;">
                            <td style="padding: 0.5rem; "><b class="mr-2">Guest's Name:</b> {{ ucwords(strtolower($booking->guest->guest_name)) }}</td>
                            <td style="padding: 0.5rem; "> <b class="mr-2">Booking From: </b>{{ date('d/M/Y', strtotime($booking->booking_from)) }} <b>To </b>
                                 {{ date('d/M/Y', strtotime($booking->booking_to)) }}</td>  <td style="padding: 0.5rem; "><b class="mr-2">Booking Purpose:</b> {{ $booking->purpose }}</td>
                            
                        </tr>

                        <tr style="border-bottom: 1px solid #D1D5DB;">
                          
                        
                        </tr>
                        <tr style="border-bottom: 1px solid #D1D5DB;">
                            <td style="padding: 0.5rem; "><b class="mr-2">Number of Rooms:</b>{{ str_pad($booking->num_rooms, 2, '0', STR_PAD_LEFT) }}</td>
                            <td style="padding: 0.5rem;"><b class="mr-2">Number of Days:</b>{{ str_pad($booking->num_days, 2, '0', STR_PAD_LEFT) }}</td>
                            <td style="padding: 0.5rem;"><b class="mr-2">Total Guests:</b>{{ str_pad($booking->totalguests, 2, '0', STR_PAD_LEFT) }}</td>
                        </tr>
                    
                        
                    </tbody>
                </table>
            </div>

            <!-- Payment Status -->
            <div class="mt-4 text-right">
                <span class="bg-yellow-300 px-2 py-1 font-bold">
                    Payment Status: {{ ucfirst($payment->due) }}
                </span>
            </div>
            <form wire:submit.prevent="updateBill" class="space-y-4 z-25 relative grid grid-cols-1 sm:grid-cols-2 gap-4"
                enctype="multipart/form-data">
                <div>
                    <flux:field>
                        <flux:label>Advanced Paid</flux:label>
                        <flux:input  type="text" placeholder="Advance Paid" value="{{ $payment->advance }}" />
                        
                    </flux:field>
                </div>
                <div>
                    <flux:field>
                        <flux:label>Total Charges </flux:label>
                        <flux:input  type="text" placeholder="Total" value="{{ $payment->total }}" />
                    
                    </flux:field>
                </div>

                <div>
                    <flux:field>
                        <flux:label>Balance (Total- Advanced)</flux:label>
                        <flux:input  type="text" placeholder="Total" value="{{ $payment->total -$payment->advance}}" />
                    
                    </flux:field>
                </div>

                <div>
                    <flux:field>
                        <flux:label>Payment Today</flux:label>
                        <flux:input wire:model="payment_today" type="number" placeholder="Total" value="0" />
                        <flux:error name="payment_today" />
                    </flux:field>
                </div>
                <flux:button type="submit" variant="primary" class="mt-6">Update Canteen Bill</flux:button>
            </form>

            <!-- Charges Table -->



          



            
        </div>

    </div>
</div>

