<div class="h-full w-full">
    <!-- Grid with 2 columns by default and 3 columns on medium and above screens -->
    <div class="relative h-full flex-1 rounded-xl border border-gray-300 px-4 pb-4">
        <!-- Placeholder pattern (Ensure this doesn't overlap the form) -->
        <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/15 z-0 pointer-events-none" />

        <div class="relative mb-0 p-4 w-full z-10">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-3xl text-red-900">Update Profile</h1>
                    <flux:subheading size="lg" class="mb-2">{{ __('Complete your profile to register with EDC.') }}
                    </flux:subheading>
                </div>
                <div>
                    <img src="{{ Auth()->user()->avatar ? asset('storage/' . Auth()->user()->avatar) : asset('images/profile.png') }}"
                        class="w-16 border-1 p-1 rounded-full border-gray-700" />
                </div>
            </div>
            <hr style="height:1px;border-width:0;color:gray;background-color:gray" />
        </div>
        <div class="mt-0 flex justify-end">
            <flux:button type="submit" variant="filled" class="ml-auto border border-gray-400" size="sm">Back to
                Profile</flux:button>
        </div>
        <div class="w-full mx-auto">

            <form wire:submit.prevent="update" class="space-y-4 z-10 relative grid grid-cols-1 sm:grid-cols-2 gap-4"
                enctype="multipart/form-data">

                <!-- First column -->
                <flux:field>
                    <flux:label>Full Name </flux:label>

                    <div class="w-full border h-10 px-3 pt-2 rounded-lg bg-gray-200">{{ Auth()->user()->name }}</div>
                    <flux:error name="name" />
                </flux:field>

                <flux:field>
                    <flux:label>Email (readonly)</flux:label>
                    <div class="w-full border h-10 px-3 pt-2 rounded-lg bg-gray-200">{{ Auth()->user()->email }}</div>
                </flux:field>

                <!-- Second column -->
                <div class="my-auto">
                    <flux:field>
                        <flux:label>Phone No.</flux:label>
                        <flux:input wire:model="phone" type="text" placeholder="Phone/Mobile" />
                        <flux:error name="phone" />
                    </flux:field>
                </div>

                <flux:field>
                    <flux:textarea wire:model="address" rows="3" label="Address"
                        placeholder="Enter your Complete Address" />
                </flux:field>

                <!-- 3rd row for User Type -->
                <div>
                    <flux:label>Choose User Type</flux:label>

                    <!-- Radio buttons for selecting user_type -->
                    {{--  <input type="radio" id="employee" name="user_type" value="Employee" onchange="toggleUserType()">
                     <label for="employee">Employee</label><br>
                 
                     <input type="radio" id="student" name="user_type" value="Student" onchange="toggleUserType()">
                     <label for="student">Student</label><br> --}}
                    <div class="flex gap-4 ">
                        <div
                            class="w-1/2 h-10 mt-2 flex items-center ps-4 border border-gray-200 bg-gray-100 rounded-sm dark:border-gray-700">
                            <input id="bordered-radio-1" wire:model="user_type" type="radio" value="Employee"
                                name="user_type" onchange="toggleUserType()" class="w-4 h-4 focus:ring-2" disabled
                                readonly>
                            <label for="bordered-radio-1"
                                class="w-full py-4 ms-2 text-sm font-medium text-gray-900 dark:text-gray-300">Employee</label>
                        </div>
                        <div
                            class="w-1/2 flex mt-2 items-center ps-4 border border-gray-200 bg-gray-100  rounded-sm dark:border-gray-700">
                            <input checked id="bordered-radio-2" wire:model="user_type" type="radio" value="Student"
                                name="user_type" onchange="toggleUserType()" class="w-4 h-4 focus:ring-2
    " disabled
                                readonly>
                            <label for="bordered-radio-2" class="w-full text-sm px-2">Student</label>
                        </div>
                    </div>

                    {{--   <flux:radio.group wire:model="user_type" variant="segmented" style="background: rgb(220, 218, 218)">
                        <flux:radio label="Employee" icon="user" value="Employee" />
                        <flux:radio label="Student" icon="book-open-text" value="Student" />
                        <flux:error name="user_type" />
                    </flux:radio.group> --}}
                </div>

                <!-- Conditional Employee Id / Registration No.== 'Employee' ? 'Employee Id' : 'Registration No.' -->
                {{--   <flux:field>
                    <flux:label> {{ $user_type == 'Employee' ? 'Employee Id' : 'Registration No.' }}  (readonly)</flux:label>
                    <div class="w-full border h-10 px-3 pt-2 rounded-lg bg-gray-200">{{ Auth()->user()->unique_id }}</div>
                </flux:field> --}}


                <flux:field>
                    <label for="employee">{{ $user_type == 'Employee' ? 'Employee Id' : 'Registration No.' }}
                        (readonly)</label>
                    <div class="w-full border h-10 px-3 pt-2 mb-2 rounded-lg bg-gray-200">
                        {{ Auth::user()->unique_id }} <!-- Assuming unique_id exists for the user -->
                    </div>
                </flux:field>




                <!-- Department Selection -->
                <div>
                    <flux:label>Department</flux:label>{{ $user_type }}
                    <flux:select wire:model="department" >
                        <flux:select.option value="" selected>Choose Department ...</flux:select.option>
                        @foreach (config('helpers.departments_all') as $value)
                            <flux:select.option>{{ $value }}</flux:select.option>
                        @endforeach
                    </flux:select>
                    <flux:error name="department" />
                </div>

                <!-- Conditional Designation or Course -->
                <div>
                    <flux:label>{{ $user_type == 'Employee' ? 'Select Designation' : 'Choose Course' }}</flux:label>
                    <flux:select wire:model="designation"
                        placeholder="{{ $user_type == 'Employee' ? 'Choose Designation...' : 'Choose Course...' }}">
                        @if ($user_type == 'Employee')
                        <flux:select.option value="" selected>Choose Designation</flux:select.option>
                            @foreach (config('helpers.designation_all') as $value)
                                <flux:select.option>{{ $value }}</flux:select.option>
                            @endforeach
                        @elseif ($user_type == 'Student')
                        <flux:select.option value="" selected>Choose Course ...</flux:select.option>
                            @foreach (config('helpers.courses_all') as $value)
                                <flux:select.option>{{ $value }}</flux:select.option>
                            @endforeach
                        @else
                            <flux:select.option>Choose User Type (Employee or Student) </flux:select.option>
                        @endif
                    </flux:select>
                    <flux:error name="designation" />
                </div>

                <!-- Profile Picture Upload -->
                <div class="flex gap-4">
                    <flux:input type="file" wire:model="avatar" label="Your Profile Pic (Optional)"
                     />
                    @if ($avatar)
                        @if (in_array(strtolower($avatar->getClientOriginalExtension()), ['jpeg', 'jpg', 'png', 'gif']))
                            <img src="{{ $avatar->temporaryUrl() }}" class="h-16 w-16 object-cover rounded-full" />
                    

                    @else
                            <!-- Optionally, show a message or icon if a non-image file is uploaded -->
                           <br> <div class="text-red-500 flex col">Invalid file type. Please select an image.</div>
                        @endif
                    @endif
                     </div>
                
                <!-- Submit Button -->
                <flux:button type="submit" variant="primary">Update Profile</flux:button>
            </form>
        </div>
    </div>
</div>
<!-- JavaScript to toggle the display -->
<script>
    // Function to toggle visibility of fields based on radio button selection
    function toggleUserType() {

        const userType = document.querySelector('input[name="user_type"]:checked').value;

        @this.set('user_type', userType);
        // Hide both fields initially


        // Show the appropriate field based on user selection
        if (userType === 'Employee') {
            document.getElementById("unique_id").innerHTML = 'Employee Id';
        } else if (userType === 'Student') {
            document.getElementById("unique_id").innerHTML = 'Registration No.';;
        }
    }

    // Call toggleUserType initially to set the correct field visible based on the default radio button
    document.addEventListener('DOMContentLoaded', function() {
        toggleUserType();
    });
</script>
