<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Executive Development Center, MNNIT</title>
    <script src="https://cdn.tailwindcss.com"></script> <!-- TailwindCSS CDN -->

    <style>
        /* Floating animation (not applied by default) */
        .is-floating-animated {
            transition: transform 0.3s ease-in-out;
        }

        /* Floating animation applied continuously */
        .floating {
            animation: float-up-down 2s ease-in-out infinite both;
        }

        /* Keyframes for the float-up-down effect */
        @keyframes float-up-down {
            0% {
                transform: translateY(0);
            }
            50% {
                transform: translateY(-3%);
            }
            100% {
                transform: translateY(0);
            }
        }
    </style>
</head>
<body >

    <nav class="bg-gray-700 p-4 z-30 relative">
        <div class="max-w-screen-lg mx-auto flex justify-between items-center">
            <!-- Logo Section -->
            <div class="flex text-white font-bold text-lg items-center gap-2">
                <a href="#"><img src="/images/menu_logo2.png" class="border w-3/4 h-16 px-1 rounded-lg shadow-lg"></a>
            </div>

            <!-- Menu (Desktop) -->
            <div class="hidden md:flex space-x-6">
                               <a href="<?php echo e(asset('docs/Revised_Tariff_Food_Charges_EDC_10.08.2022.pdf')); ?>" target="_blank" class="text-white hover:text-gray-300 border-b border-yellow-500 hover:border-gray-300 p-4">Traiffs</a>

                <a href="#" class="text-white hover:text-gray-400 border-b border-yellow-500 p-4">Terms & Conditions</a>
                <a href="#" class="text-white hover:text-gray-400 border-b border-yellow-500 p-4">Contact Us</a>
                <?php if(Route::has('login')): ?>
                <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(url('/dashboard')); ?>" class="text-white hover:text-gray-400 border-b border-yellow-500 p-4">Dashboard</a>
                <?php else: ?>
                    <a href="<?php echo e(route('login')); ?>" class="text-white hover:text-gray-400 border-b border-yellow-500 p-4">Login</a>
                    <?php if(Route::has('register')): ?>
                        <a href="<?php echo e(route('register')); ?>" class="text-white hover:text-gray-400 border-b border-yellow-500 p-4">Register</a>
                    <?php endif; ?>
                <?php endif; ?>
                <?php endif; ?>

                
            </div>

            <!-- Mobile Hamburger Menu -->
            <div class="md:hidden z-40">
                <button id="mobile-menu-button" class="text-white">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </div>
        </div>

        <!-- Mobile Menu (hidden by default) -->
        <div id="mobile-menu" class="md:hidden hidden bg-gray-700 text-white transition-all duration-300 ease-in-out transform opacity-0 translate-y-4">
            <div class="flex flex-col space-y-4 p-4">
                <a href="#" class="hover:text-gray-400">Traiffs</a>
                <a href="#" class="hover:text-gray-400">Terms & Conditions</a>
                <a href="#" class="hover:text-gray-400">Contact Us</a>
                <a href="#" class="hover:text-gray-400">Login</a>
                <a href="#" class="hover:text-gray-400">Register</a>
            </div>
        </div>
    </nav>
  
    <!-- Background Content, ensure it doesn't block clicks -->
    <div class="h-full w-full border-neutral-200 dark:border-neutral-700 z-10 pointer-events-none mt-10">
        <?php if (isset($component)) { $__componentOriginal1e4630c5daeca7ac226f30794c203a2d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1e4630c5daeca7ac226f30794c203a2d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.placeholder-pattern','data' => ['class' => 'absolute inset-0 size-full stroke-gray-900/20 dark:stroke-neutral-100/20']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('placeholder-pattern'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'absolute inset-0 size-full stroke-gray-900/20 dark:stroke-neutral-100/20']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1e4630c5daeca7ac226f30794c203a2d)): ?>
<?php $attributes = $__attributesOriginal1e4630c5daeca7ac226f30794c203a2d; ?>
<?php unset($__attributesOriginal1e4630c5daeca7ac226f30794c203a2d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1e4630c5daeca7ac226f30794c203a2d)): ?>
<?php $component = $__componentOriginal1e4630c5daeca7ac226f30794c203a2d; ?>
<?php unset($__componentOriginal1e4630c5daeca7ac226f30794c203a2d); ?>
<?php endif; ?> 
      <!-- Here -->
      <div class="text-4xl text-center "><span class="[text-shadow:_0_8px_8px_rgb(99_102_241_/_0.6)] text-gray-700">Motilal Nehru National Institute of Technology Allahabad, Prayagraj (MNNIT)</span></div>
      <div class="flex items-center justify-center w-full transition-opacity opacity-100 duration-750 lg:grow starting:opacity-0 mt-10">
        <main class="flex max-w-[700px] w-full flex-col-reverse lg:max-w-5xl lg:flex-row">
            <div class="text-[16px] leading-[20px] flex-1 p-6 pb-12 lg:py-8 lg:px-8 bg-white dark:bg-[#161615] dark:text-[#EDEDEC] shadow-[inset_0px_0px_0px_1px_rgba(26,26,0,0.16)] dark:shadow-[inset_0px_0px_0px_1px_#fffaed2d] rounded-bl-lg rounded-br-lg lg:rounded-tl-lg lg:rounded-br-none text-center">
                <h1 class="mb-1 font-medium text-2xl text-yellow-800"><u>Executive Development Center</u></h1>
                <img src="images/mnnit_logo.png" class="w-1/2 border border-blue-900 p-2 rounded-lg mx-auto">
                
               
               
              <?php if(Route::has('login')): ?>
              <?php if(auth()->guard()->check()): ?>
                  <a href="<?php echo e(url('/dashboard')); ?>" class="inline-block hover:bg-black hover:border-black px-5 py-1.5 transition duration-500 ease-in-out bg-[#1b1b18] rounded-sm border border-black text-yellow-500 text-sm leading-normal mt-5 transform hover:-translate-y-1 hover:scale-110 z-50 pointer-events-auto">
                      Dashboard
                  </a>
              <?php else: ?>
                  <a href="<?php echo e(route('login')); ?>" class="inline-block hover:bg-black hover:border-black px-5 py-1.5 transition duration-500 ease-in-out bg-[#1b1b18] rounded-sm border border-black text-yellow-500 text-sm leading-normal mt-5 transform hover:-translate-y-1
                  z-50 pointer-events-auto me-2">
                      Login Here
                  </a>
          
                  <?php if(Route::has('register')): ?>
                      <a href="<?php echo e(route('register')); ?>" class="inline-block hover:bg-black hover:border-black px-5 py-1.5 transition duration-500 ease-in-out bg-[#1b1b18] rounded-sm border border-black text-yellow-500 text-sm leading-normal mt-5 transform hover:-translate-y-1  z-50 pointer-events-auto ml-2">
                          Register
                      </a>
                  <?php endif; ?>
              <?php endif; ?>
          <?php endif; ?>
                     
            </div>
            <div class="bg-[#fff2f2] dark:bg-[#1D0002] relative lg:-ml-px -mb-px lg:mb-0 rounded-t-lg lg:rounded-t-none lg:rounded-r-lg aspect-[335/376] lg:aspect-auto w-full lg:w-[580px] shrink-0 overflow-hidden">
                
                
                <div class="absolute inset-0 rounded-t-lg lg:rounded-t-none lg:rounded-r-lg shadow-[inset_0px_0px_0px_1px_rgba(26,26,0,0.16)] dark:shadow-[inset_0px_0px_0px_1px_#fffaed2d]">
                    <div class="has-floating-animation h-full w-full">
                        <img id="floating-image" src="/images/edc_pic2.jpg" class="is-floating-animated border w-full rounded-xl bg-cover h-full shadow-lg">

                    </div>
                     
                
                </div>
            </div>
        </main>
    </div>
      <!-- End Here -->
      <div class="mt-20 text-center text-gray-600"> Copyright © EDC,  MNNIT Allahabad. All rights reserved. </div>
    </div>

    <!-- Add JavaScript for toggle functionality -->
    <script>
        // Wait for the DOM to fully load
        document.addEventListener('DOMContentLoaded', function () {
            const mobileMenuButton = document.getElementById('mobile-menu-button');
            const mobileMenu = document.getElementById('mobile-menu');

            // Toggle mobile menu visibility when the button is clicked
            mobileMenuButton.addEventListener('click', () => {
                mobileMenu.classList.toggle('hidden');
                // Add transition effects for the mobile menu
                if (!mobileMenu.classList.contains('hidden')) {
                    mobileMenu.classList.remove('opacity-0', 'translate-y-4');
                    mobileMenu.classList.add('opacity-100', 'translate-y-0');
                } else {
                    mobileMenu.classList.remove('opacity-100', 'translate-y-0');
                    mobileMenu.classList.add('opacity-0', 'translate-y-4');
                }
            });
        });


        // Get the image element
        const image = document.getElementById('floating-image');

        // Add the floating animation class immediately when the page loads
        window.addEventListener('load', function() {
            image.classList.add('floating');
        });
    </script>

</body>
</html>
<?php /**PATH /home/u301157799/domains/sagaciouslab.in/public_html/vue/resources/views/welcome.blade.php ENDPATH**/ ?>