<?php

namespace App\Models {

    /**
     * App\Models\Booking
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $supporting_doc
     * @property string|null $comment
     * @property mixed $num_rooms
     * @property mixed $num_days
     * @property mixed $totalguests
     * @property string $follow_up
     * @property string|null $booking_id
     * @property mixed $booking_status
     * @property string|null $canteen_preference
     * @property mixed $floor_preference
     * @property \Illuminate\Support\Carbon|null $booking_to
     * @property \Illuminate\Support\Carbon|null $booking_from
     * @property string|null $payee
     * @property string|null $purpose_details
     * @property string|null $purpose
     * @property mixed $guest_id
     * @property mixed $user_id
     * @property int $id
     * @property-read \App\Models\User $user
     * @property-read \App\Models\Guest $guest
     * @property-read \App\Models\Payment $payment
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereGuestId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking wherePurpose($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking wherePurposeDetails($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking wherePayee($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereBookingFrom($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereBookingTo($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereFloorPreference($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereCanteenPreference($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereBookingStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereBookingId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereFollowUp($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereTotalguests($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereNumDays($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereNumRooms($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereComment($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereSupportingDoc($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking search()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking query()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Booking|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Booking|null first(array|string $columns)
     * @method static Booking firstOrFail(array|string $columns, string|null $message)
     * @method static Booking sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Booking>|Booking tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Booking extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Canteen
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property float $total
     * @property mixed $qty
     * @property float $rate
     * @property string $particulars
     * @property string $category
     * @property mixed $canteen_payment_id
     * @property int $id
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereCanteenPaymentId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereCategory($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereParticulars($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereRate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereQty($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereTotal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen query()
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Canteen|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Canteen|null first(array|string $columns)
     * @method static Canteen firstOrFail(array|string $columns, string|null $message)
     * @method static Canteen sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Canteen>|Canteen tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Canteen extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\CanteenPayment
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string $due
     * @property float $total
     * @property float $advance
     * @property string $booking_id
     * @property int $id
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereBookingId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereAdvance($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereTotal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereDue($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment query()
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static CanteenPayment|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment clone()
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static CanteenPayment|null first(array|string $columns)
     * @method static CanteenPayment firstOrFail(array|string $columns, string|null $message)
     * @method static CanteenPayment sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<CanteenPayment>|CanteenPayment tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class CanteenPayment extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Guest
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $guest_idno
     * @property string|null $guest_idtype
     * @property string|null $guest_relation
     * @property string|null $guest_phone
     * @property string|null $guest_gender
     * @property string|null $guest_email
     * @property string|null $state
     * @property string|null $city
     * @property string|null $address
     * @property string|null $guest_name
     * @property mixed $user_id
     * @property int $id
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\GuestAccompanying> $guestAccompaying
     * @property-read int|null $guestAccompaying_count
     * @property-read \App\Models\Booking $booking
     * @property-read \App\Models\User $user
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereGuestName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereAddress($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereCity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereState($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereGuestEmail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereGuestGender($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereGuestPhone($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereGuestRelation($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereGuestIdtype($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereGuestIdno($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest query()
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Guest|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Guest|null first(array|string $columns)
     * @method static Guest firstOrFail(array|string $columns, string|null $message)
     * @method static Guest sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Guest>|Guest tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Guest extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\GuestAccompanying
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $accompaying_idno
     * @property string|null $accompaying_idtype
     * @property string|null $accompaying_relation
     * @property string|null $accompaying_gender
     * @property mixed $accompaying_age
     * @property string|null $accompaying_name
     * @property mixed $guest_id
     * @property int $id
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereGuestId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereAccompayingName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereAccompayingAge($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereAccompayingGender($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereAccompayingRelation($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereAccompayingIdtype($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereAccompayingIdno($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying query()
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static GuestAccompanying|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying clone()
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static GuestAccompanying|null first(array|string $columns)
     * @method static GuestAccompanying firstOrFail(array|string $columns, string|null $message)
     * @method static GuestAccompanying sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<GuestAccompanying>|GuestAccompanying tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class GuestAccompanying extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Post
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property int $id
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post query()
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Post|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Post|null first(array|string $columns)
     * @method static Post firstOrFail(array|string $columns, string|null $message)
     * @method static Post sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Post>|Post tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Post extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Room
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string $is_occupied
     * @property string $is_operational
     * @property mixed $type
     * @property string|null $floor
     * @property string|null $room_name
     * @property int $id
     * @property-read \App\Models\Booking $booking
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\RoomList> $roomlist
     * @property-read int|null $roomlist_count
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereRoomName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereFloor($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereIsOperational($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereIsOccupied($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room query()
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Room|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Room|null first(array|string $columns)
     * @method static Room firstOrFail(array|string $columns, string|null $message)
     * @method static Room sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Room>|Room tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Room extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\RoomList
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property mixed $occupancy
     * @property mixed $room_id
     * @property string|null $booking_id
     * @property int $id
     * @property-read \App\Models\Room $room
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereBookingId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereRoomId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereOccupancy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList query()
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static RoomList|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList clone()
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static RoomList|null first(array|string $columns)
     * @method static RoomList firstOrFail(array|string $columns, string|null $message)
     * @method static RoomList sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<RoomList>|RoomList tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class RoomList extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\User
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $remember_token
     * @property string $avatar
     * @property mixed $role
     * @property mixed $status
     * @property string|null $designation
     * @property string|null $department
     * @property mixed $user_type
     * @property string|null $address
     * @property string|null $phone
     * @property string $password
     * @property string $unique_id
     * @property \Illuminate\Support\Carbon|null $email_verified_at
     * @property string $email
     * @property string $name
     * @property int $id
     * @property-read \App\Models\Guest $guest
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Illuminate\Notifications\DatabaseNotification> $notifications
     * @property-read int|null $notifications_count
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmailVerifiedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereUniqueId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePassword($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePhone($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAddress($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereUserType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereDepartment($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereDesignation($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRole($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAvatar($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRememberToken($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User query()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User select(array|mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addSelect(array|mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRaw(string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, string|int|float|null $operator, string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static User|null find(int|string $id, array|string $columns)
     * @method static mixed findOr(mixed $id, callable|list<string>|string $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(array|string $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, array|string $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, array|string $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination(array $columns)
     * @method static array runPaginationCountQuery(array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User cloneForPaginationCount()
     * @method static array withoutSelectAliases()
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User setAggregate(string $function, array $columns)
     * @method static mixed onceWithColumns(array $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert(array|string $uniqueBy, array|null $update)
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static array getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static array getBindings()
     * @method static array getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User setBindings(string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addBinding(mixed $value, string $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User mergeBindings()
     * @method static array cleanBindings()
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User clone()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static User|null first(array|string $columns)
     * @method static User firstOrFail(array|string $columns, string|null $message)
     * @method static User sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User tap(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class User extends \Illuminate\Foundation\Auth\User
    {
        //
    }

}