<!-- Background Content, ensure it doesn't block clicks -->
@include('frontend_partials.head')

<div class="h-full w-full border-neutral-200 dark:border-neutral-700 z-10 pointer-events-none mt-10">
    <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/20 dark:stroke-neutral-100/20" />
    <!-- Here -->

    <div
        class="flex items-center justify-center w-full transition-opacity opacity-100 duration-750 lg:grow starting:opacity-0 mt-10">
        <main class="flex max-w-[700px] w-full flex-col-reverse lg:max-w-5xl lg:flex-row">

            <section class="mb-12">
                <h2 class="text-2xl font-semibold text-blue-800 mb-4 border-b pb-2">About EDC</h2>
                <p class="mb-4 text-gray-700">The Executive Development Center (EDC) is a dedicated facility at
                    Motilal Nehru National Institute of Technology (MNNIT) Allahabad, designed to support executive
                    education, training programs, workshops, and conferences. It serves as a hub for academic and
                    professional development activities, catering to the needs of both internal and external
                    participants.</p>

                <div class="mb-8">
                    <h3 class="text-xl font-medium text-blue-700 mb-3">Facilities and Accommodation</h3>
                    <ul class="list-disc pl-6 space-y-2 text-gray-700">
                        <li>The EDC offers accommodation with 37 rooms, available through advance booking on a
                            prescribed format. All official bookings require prior approval</li>
                        <li>The center is located within the MNNIT staff colony, providing convenient access for
                            participants attending events at the institute.</li>
                        <li>Accommodation at the EDC is subject to availability and is typically allocated on a
                            first-come, first-served basis. Charges for the stay are borne by the participants.</li>
                        <li>The EDC is often used for short-term stays, such as during conferences, workshops, and
                            training programs. Requests for one- or two- or three days- stays can be made through
                            the concerned warden or the officer in charge of the EDC.</li>
                    </ul>
                </div>

                <div>
                    <h3 class="text-xl font-medium text-blue-700 mb-3">Purpose and Activities</h3>
                    <ul class="list-disc pl-6 space-y-2 text-gray-700">
                        <li>The EDC is primarily used for hosting executive development programs, faculty
                            development programs (FDPs), workshops, seminars, and conferences organized by various
                            departments of MNNIT Allahabad.</li>
                        <li>It provides a conducive environment for professional learning and networking among
                            participants from academia, industry, and government sectors.</li>
                    </ul>
                </div>
            </section>
        </main>
    </div>
    <div
        class="flex items-center justify-center w-full transition-opacity opacity-100 duration-750 lg:grow starting:opacity-0 mt-10">

        <main class="flex max-w-[700px] w-full flex-col-reverse lg:max-w-5xl lg:flex-row">

            <section class="mb-12">
                <div class="bg-white rounded-lg shadow-md p-6 mb-8">
                    <h2 class="text-2xl font-semibold text-blue-800 mb-4">Location and Overview</h2>
                    <p class="text-gray-700 mb-4">
                        The Executive Development Center (EDC) is a dedicated facility within the Motilal Nehru
                        National Institute of Technology (MNNIT), located in Teliarganj, Prayagraj (formerly
                        Allahabad), Uttar Pradesh. The campus spans 222 acres and is a prominent destination for
                        academic and professional events.
                    </p>
                </div>

                <div class="grid md:grid-cols-1 gap-6">
                    <!-- By Air Card -->
                    <div class="bg-white rounded-lg shadow-md overflow-hidden">
                        <div class="bg-blue-700 text-white p-4">
                            <h3 class="text-xl font-semibold">By Air</h3>
                        </div>
                        <div class="p-6">
                            <h4 class="font-semibold text-blue-800 mb-2">Nearest Airport</h4>
                            <p class="text-gray-700 mb-4">
                                The nearest airport to MNNIT Allahabad is Prayagraj Airport, which is situated
                                approximately 12-14 kilometers from the MNNIT campus. This airport has direct
                                flights connecting to major Indian cities such as Delhi, Mumbai, Bhubaneswar &
                                Bangalore, etc.
                            </p>

                            <h4 class="font-semibold text-blue-800 mb-2">Travel Steps from Airport to EDC</h4>
                            <ol class="list-decimal pl-6 space-y-2 text-gray-700">
                                <li class="mb-2">
                                    <span class="font-medium">Arrival at Prayagraj Airport:</span><br>
                                    Land at Prayagraj Airport (IATA: IXD).
                                </li>
                                <li class="mb-2">
                                    <span class="font-medium">Local Transport Options:</span>
                                    <ul class="list-disc pl-6 mt-1">
                                        <li>Taxi/Cab: Prepaid taxis and app-based cab services (like Ola, Uber, or
                                            local providers) are available at the airport.</li>
                                        <li>Auto-rickshaw: For budget travel, auto-rickshaws are available, though
                                            less comfortable for longer distances.</li>
                                    </ul>
                                </li>
                                <li class="mb-2">
                                    <span class="font-medium">Route to MNNIT Allahabad:</span>
                                    <ul class="list-disc pl-6 mt-1">
                                        <li>The campus is located in Teliarganj, which is well-known in Prayagraj.
                                        </li>
                                        <li>The drive from the airport to MNNIT typically takes 30–40 minutes,
                                            depending on traffic.</li>
                                    </ul>
                                </li>
                                <li>
                                    <span class="font-medium">On-Campus Directions:</span>
                                    <ul class="list-disc pl-6 mt-1">
                                        <li>Upon reaching the main gate of MNNIT Allahabad, inform security or the
                                            gate staff that you are visiting the Executive Development Center (EDC).
                                        </li>
                                        <li>The EDC is a recognized facility within the campus, and directions or an
                                            escort can be provided at the gate.</li>
                                    </ul>
                                </li>
                            </ol>
                        </div>
                        <div class="flex items-center justify-center">
                            <img src="{{ asset('images/air_map.jpg') }}" class="shadow-lg h-100" width="800" />
                        </div>
                    </div>

                    <!-- By Train Card -->
                    <div class="bg-white rounded-lg shadow-md overflow-hidden">
                        <div class="bg-blue-700 text-white p-4">
                            <h3 class="text-xl font-semibold">By Train</h3>
                        </div>
                        <div class="p-6">
                            <h4 class="font-semibold text-blue-800 mb-2">Step 1: Arrive at Prayagraj Junction</h4>
                            <p class="text-gray-700 mb-4">
                                Prayagraj Junction (formerly Allahabad Junction) is the main railway station in the
                                city and is well connected to major cities across India by numerous daily trains.
                            </p>

                            <h4 class="font-semibold text-blue-800 mb-2">Step 2: From Railway Station to MNNIT</h4>
                            <p class="text-gray-700 mb-2">
                                The distance from Prayagraj Junction to the MNNIT Allahabad campus is approximately
                                8 km. MNNIT is located in the Teliyarganj locality of Prayagraj (Allahabad).
                            </p>

                            <h4 class="font-semibold text-blue-800 mb-2">Transport Options:</h4>
                            <ul class="list-disc pl-6 space-y-2 text-gray-700 mb-4">
                                <li>
                                    <span class="font-medium">Auto-rickshaw:</span> You can hire a private
                                    auto-rickshaw directly to MNNIT. The fare is about ₹150. Tell the driver to take
                                    you to the "Motilal Nehru Engineering College guest house (Executive Development
                                    Centre)" which is in the MNNIT staff colony, in front of the railway crossing.
                                </li>
                                <li>
                                    <span class="font-medium">Taxi:</span> Taxis are available outside the railway
                                    station, with fares around ₹300 for a direct trip to MNNIT.
                                </li>
                                <li>
                                    <span class="font-medium">Sharing Auto:</span> Sharing autos are a
                                    budget-friendly option. These pass through the MNNIT gate. Get down at the Ganga
                                    gate of MNNIT and then either take a rickshaw or walk (~1 km) across the campus
                                    to reach the EDC.
                                </li>
                                <li>
                                    <span class="font-medium">Bus:</span> City buses from the railway station to
                                    Teliyarganj or Govindpur pass by MNNIT.
                                </li>
                            </ul>

                            <h4 class="font-semibold text-blue-800 mb-2">Step 3: Inside the Campus</h4>
                            <p class="text-gray-700 mb-2">
                                The Executive Development Center (EDC) is located within the MNNIT staff colony,
                                near the main entrance.
                            </p>
                            <p class="text-gray-700">
                                If you arrive at the main gate (Ganga gate), you may need to take a rickshaw or walk
                                to the EDC, which is about 1 km inside the campus.
                            </p>

                            <div class="bg-blue-50 p-4 mt-4 rounded border border-blue-100">
                                <h4 class="font-semibold text-blue-800 mb-2">Additional Notes:</h4>
                                <ul class="list-disc pl-6 space-y-1 text-gray-700">
                                    <li>MNNIT offers a transport facility for pick-up and drop-off at the railway
                                        station upon early request, which can be arranged in advance if you are a
                                        guest or participant in an official event.</li>
                                    <li>The EDC has accommodation facilities, so if you have a booking, mention this
                                        to the auto/taxi driver for easier navigation.</li>
                                </ul>
                            </div>
                        </div>

                        <div class="flex items-center justify-center">
                            <img src="{{ asset('images/train_map.jpg') }}" class="shadow-lg h-100" width="800" />
                        </div>
                    </div>

                    <!-- By Road/Bus Card -->
                    <div class="bg-white rounded-lg shadow-md overflow-hidden">
                        <div class="bg-blue-700 text-white p-4">
                            <h3 class="text-xl font-semibold">By Road or Bus</h3>
                        </div>
                        <div class="p-6">
                            <h4 class="font-semibold text-blue-800 mb-2">Location Overview</h4>
                            <p class="text-gray-700 mb-4">
                                The Executive Development Center (EDC) is located within the Motilal Nehru National
                                Institute of Technology (MNNIT) campus in the Teliyarganj locality of Prayagraj
                                (Allahabad), Uttar Pradesh. The campus is well connected by road and public
                                transport to the rest of the city and nearby regions.
                            </p>

                            <h4 class="font-semibold text-blue-800 mb-2">By Road (Private Vehicle or Taxi/Auto)
                            </h4>
                            <ul class="list-disc pl-6 space-y-2 text-gray-700 mb-4">
                                <li>From any part of Allahabad city, you can reach MNNIT by hiring an auto-rickshaw
                                    or taxi.</li>
                                <li>If coming from Allahabad Junction railway station, you can take an auto (approx.
                                    fare ₹150) or a taxi (approx. fare ₹300) and ask to be dropped at the Motilal
                                    Nehru Engineering College Guest House (Executive Development Center), located in
                                    the MNNIT staff colony.</li>
                                <li>If you are already in the city, you can also reach Hanuman Mandir (a local
                                    landmark) by rickshaw, then take a sharing auto or a private auto directly to
                                    MNNIT.</li>
                            </ul>

                            <h4 class="font-semibold text-blue-800 mb-2">By Bus (Public Transport)</h4>
                            <ul class="list-disc pl-6 space-y-2 text-gray-700">
                                <li>UPSRTC (Uttar Pradesh State Road Transport Corporation) buses connect Allahabad
                                    to major cities like Lucknow, Kanpur, and Delhi. Once you arrive at the
                                    Allahabad bus stand, you can hire an auto or taxi to MNNIT.</li>
                                <li>There are city buses from Allahabad Railway Station to Teliyarganj and Govindpur
                                    that pass by MNNIT.</li>
                                <li>Sharing autos are also available outside the railway station and pass through
                                    the MNNIT gate. Get down at the Ganga Gate of MNNIT and either take a rickshaw
                                    or walk (about 1 km) through the campus to reach the EDC.</li>
                            </ul>
                        </div>
                        <div class="flex items-center justify-center">
                            <img src="{{ asset('images/road_map.jpg') }}" class="shadow-lg h-100" width="800" />
                        </div>
                    </div>
                </div>
            </section>
        </main>
    </div>

</div>
<!-- End Here -->
<div class="mt-20 text-center text-gray-600"> Copyright © EDC, MNNIT Allahabad. All rights reserved. </div>
</div>

<!-- Add JavaScript for toggle functionality -->


</body>

</html>
