@include('frontend_partials.head')
<div class="h-full w-full border-neutral-200 dark:border-neutral-700 z-10 pointer-events-none mt-10 relative">
    <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/20 dark:stroke-neutral-100/20" />

    <!-- Your main content container -->
    <div class="container mx-auto px-4 pointer-events-auto">
        <main class="flex w-full flex-col-reverse lg:flex-row">
            <section class="bg-white rounded-lg shadow-md p-6 my-12 w-full">
                <h2 class="text-2xl font-semibold text-blue-800 mb-6 border-b pb-2">Contact Information</h2>

                <div class="grid md:grid-cols-2 gap-8 w-full">
                    <!-- Address Section -->
                    <div class="border border-gray-200 rounded-lg p-6">
                        <h3 class="text-xl font-medium text-blue-700 mb-4 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                            </svg>
                            Address
                        </h3>
                        <address class="text-gray-700 not-italic">
                            <p class="font-semibold mb-2">Executive Development Center (EDC)</p>
                            <p>MNNIT Allahabad, Residence Campus</p>
                            <p>(Near Director House)</p>
                            <p>PRAYAGRAJ - 211004 (UP)</p>
                        </address>

                        <div class="mt-6">
                            <h4 class="font-medium text-blue-600 mb-2">Email</h4>
                            <a href="mailto:edc@mnnit.ac.in" class="text-blue-700 hover:underline flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                </svg>
                                edc@mnnit.ac.in
                            </a>
                        </div>
                    </div>

                    <!-- Contact Persons Section -->
                    <div class="border border-gray-200 rounded-lg p-6">
                        <h3 class="text-xl font-medium text-blue-700 mb-4 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                            </svg>
                            Contact Persons
                        </h3>

                        <ul class="space-y-4">
                            <li>
                                <p class="font-semibold text-gray-800">Prof. Animesh Kumar Ojha</p>
                                <p class="flex text-gray-600">FI, EDC <svg xmlns="http://www.w3.org/2000/svg"
                                        class="h-5 w-5 mr-2 ml-5" fill="none" viewBox="0 0 24 24"
                                        stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                    </svg>
                                    0532-227-1093</p>

                            </li>

                            <li>
                                <p class="font-semibold text-gray-800">Dr. Anubhav Rawat</p>
                                <p class=flex "text-gray-600">AFI, EDC <svg xmlns="http://www.w3.org/2000/svg"
                                        class="h-5 w-5 mr-2 ml-5" fill="none" viewBox="0 0 24 24"
                                        stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                    </svg>
                                    0532-227-1205</p>

                            </li>

                            <li>
                                <p class="font-semibold text-gray-800">Mr. Nafees Ahmad</p>
                                <p class="flex text-gray-600">Academic Support Staff, EDC <svg
                                        xmlns="http://www.w3.org/2000/svg" class="ml-5 h-5 w-5 mr-2" fill="none"
                                        viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                    </svg>
                                    8687170178 </p>

                            </li>

                            <li class="flex gap-20">
                                <div>
                                    <p class="font-semibold text-gray-800">Reception</p>
                                    <p class="text-blue-700 mt-1 flex items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none"
                                            viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                        </svg>
                                        7783907141
                                    </p>
                                </div>

                            </li>


                        </ul>
                    </div>
                </div>

                <div class="border border-gray-200 rounded-lg overflow-hidden">
                    <iframe
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d7202.891616688662!2d81.86542870048534!3d25.49017446583146!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x399ab58130ad1323%3A0x657d61aa7f2d1a63!2sExecutive%20Development%20Centre%2C%20MNNIT!5e0!3m2!1sen!2sin!4v1746964500778!5m2!1sen!2sin"
                        style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"
                        width="100%" height="450" allowfullscreen="" class="w-full h-128"
                        title="EDC MNNIT Allahabad Location"></iframe>
                </div>

            </section>
        </main>
    </div>
</div>
<!-- End Here -->
<div class="mt-20 text-center text-gray-600"> Copyright © EDC, MNNIT Allahabad. All rights reserved. </div>
</div>

<!-- Add JavaScript for toggle functionality -->


</body>

</html>
