<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Executive Development Center, MNNIT</title>
    <script src="https://cdn.tailwindcss.com"></script> <!-- TailwindCSS CDN -->

    <style>
        /* Floating animation (not applied by default) */
        .is-floating-animated {
            transition: transform 0.3s ease-in-out;
        }

        /* Floating animation applied continuously */
        .floating {
            animation: float-up-down 2s ease-in-out infinite both;
        }

        /* Keyframes for the float-up-down effect */
        @keyframes float-up-down {
            0% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-3%);
            }

            100% {
                transform: translateY(0);
            }
        }
    </style>
</head>

<body>

    <nav class="bg-gray-700 p-4 z-30 relative">
        <div class="max-w-screen-lg mx-auto flex justify-between items-center">
            <!-- Logo Section -->
            <div class="flex text-white font-bold text-lg items-center gap-2">
                <a href="/"><img src="/images/menu_logo2.png"
                        class="border w-3/4 h-16 px-1 rounded-lg shadow-lg"></a>
            </div>

            <!-- Menu (Desktop) -->
            <div class="hidden md:flex space-x-6">
                <a href="{{ asset('docs/Revised_Tariff_Food_Charges_EDC_10.08.2022.pdf') }}" target="_blank"
                    class="text-white hover:text-gray-300 border-b border-yellow-500 hover:border-gray-300 p-4">Traiffs</a>

                <a href="{{ route('about') }}"
                    class="text-white hover:text-gray-400 border-b border-yellow-500 p-4">About Us</a>
                <a href="{{ route('contactus') }}"
                    class="text-white hover:text-gray-400 border-b border-yellow-500 p-4">Contact Us</a>
                @if (Route::has('login'))
                    @auth
                        <a href="{{ url('/dashboard') }}"
                            class="text-white hover:text-gray-400 border-b border-yellow-500 p-4">Dashboard</a>
                    @else
                        <a href="{{ route('login') }}"
                            class="text-white hover:text-gray-400 border-b border-yellow-500 p-4">Login</a>
                        @if (Route::has('register'))
                            <a href="{{ route('register') }}"
                                class="text-white hover:text-gray-400 border-b border-yellow-500 p-4">Register</a>
                        @endif
                    @endauth
                @endif


            </div>

            <!-- Mobile Hamburger Menu -->
            <div class="md:hidden z-40">
                <button id="mobile-menu-button" class="text-white">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                        xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </div>
        </div>

        <!-- Mobile Menu (hidden by default) -->
        <div id="mobile-menu"
            class="md:hidden hidden bg-gray-700 text-white transition-all duration-300 ease-in-out transform opacity-0 translate-y-4">
            <div class="flex flex-col space-y-4 p-4">
                <a href="{{ asset('docs/Revised_Tariff_Food_Charges_EDC_10.08.2022.pdf') }}" target="_blank"
                    class="hover:text-gray-400">Traiffs</a>
                <a href="{{ route('about') }}" class="hover:text-gray-400">About us</a>
                <a href="{{ route('contactus') }}" class="hover:text-gray-400">Contact Us</a>
                @if (Route::has('login'))
                    @auth
                        <a href="{{ url('/dashboard') }}" class="hover:text-gray-400">Dashboard</a>
                    @else
                        <a href="{{ route('login') }}" class="hover:text-gray-400">Login</a>
                        @if (Route::has('register'))
                            <a href="{{ route('register') }}" class="hover:text-gray-400">Register</a>
                        @endif
                    @endauth
                @endif
            </div>
        </div>
    </nav>
